<?php

namespace Database\Seeders;

use App\Models\Setting;
use Illuminate\Database\Seeder;

class SettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // general setting
        Setting::create(['setting_group' => 'general_settings', 'setting_key' => 'site_name']);
        Setting::create(['setting_group' => 'general_settings', 'setting_key' => 'tagline']);
        Setting::create(['setting_group' => 'general_settings', 'setting_key' => 'site_logo']);
        Setting::create(['setting_group' => 'general_settings', 'setting_key' => 'site_favicon']);
        Setting::create(['setting_group' => 'general_settings', 'setting_key' => 'is_page_breadcrumbs']);

        // sidebar setting
        Setting::create(['setting_group' => 'sidebar_settings', 'setting_key' => 'is_show_logo']);
        Setting::create(['setting_group' => 'sidebar_settings', 'setting_key' => 'is_show_contact_info']);
        Setting::create(['setting_group' => 'sidebar_settings', 'setting_key' => 'contact_title']);
        Setting::create(['setting_group' => 'sidebar_settings', 'setting_key' => 'contact_subtitle']);
        Setting::create(['setting_group' => 'sidebar_settings', 'setting_key' => 'is_show_subscribe']);
        Setting::create(['setting_group' => 'sidebar_settings', 'setting_key' => 'is_show_social_media']);

        Setting::create(['setting_group' => 'custom_css', 'setting_key' => 'custom_css']);

        // footer setting
        Setting::create(['setting_group' => 'footer_settings', 'setting_key' => 'footer_description']);
        Setting::create(['setting_group' => 'footer_settings', 'setting_key' => 'footer_is_show_social_media']);
        Setting::create(['setting_group' => 'footer_settings', 'setting_key' => 'copyright_text']);

        // social media settings
        Setting::create(['setting_group' => 'social_settings', 'setting_key' => 'facebook_url']);
        Setting::create(['setting_group' => 'social_settings', 'setting_key' => 'linkedin_url']);
        Setting::create(['setting_group' => 'social_settings', 'setting_key' => 'twitter_url']);
        Setting::create(['setting_group' => 'social_settings', 'setting_key' => 'youtube_url']);
        Setting::create(['setting_group' => 'social_settings', 'setting_key' => 'slack_url']);

        // contact settings
        Setting::create(['setting_group' => 'contact_settings', 'setting_key' => 'contact_phone_number']);
        Setting::create(['setting_group' => 'contact_settings', 'setting_key' => 'contact_email']);
        Setting::create(['setting_group' => 'contact_settings', 'setting_key' => 'contact_address']);

        // subscribe setting
        Setting::create(['setting_group' => 'subscribe_settings', 'setting_key' => 'subscribe_title']);
        Setting::create(['setting_group' => 'subscribe_settings', 'setting_key' => 'subscribe_description']);

        // theme setting
        Setting::create(['setting_group' => 'theme_settings', 'setting_key' => 'active_theme', 'setting_value' => 'default']);
        Setting::create(['setting_group' => 'theme_settings', 'setting_key' => 'default_theme_data', 'setting_value' => '{"hero_section":{"layout":"1","title":"Creativity In Our Blood Line","sub_title":"We deliver best problem solving solution for our client and provide finest finishing product in present and upcoming future.","action_text":"Get a Quote","background_image_url":"/static/hero_bg.jpeg","action_url":"https://google.com","social_links":{"title":"Follow Us","links":[{"title":"Facebook","url":"https://facebook.com"},{"title":"Twitter","url":"https://twitter.com"},{"title":"Instagram","url":"https://instagram.com"}]},"email_address":"mahadicreation@gmail.com","phone_number":"01722285902","photography_slider":[{"title":"Wedding","imageUrl":"/static/wedding.jpeg","href":"/service/service-details"},{"title":"Fashion","imageUrl":"/static/fashion.jpeg","href":"/service/service-details"},{"title":"Commercial","imageUrl":"/static/commercial.jpeg","href":"/service/service-details"},{"title":"Landscape","imageUrl":"/static/landscape.jpeg","href":"/service/service-details"}]},"our_fun_fact_section":{"layout":"1","title":"Our fun fact","sub_title":"Sed ut perspiciatis unde omnis iste natus error voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis.","background_color":"linear-gradient(267.18deg, #161616 0%, #080808 100%)","fun_facts":[{"title":"Global Happy Clients","value":"40K"},{"title":"Project Completed","value":"50K"},{"title":"Team Members","value":"245"},{"title":"Digital products","value":"550"}]},"service_section":{"layout":"1","title":"What Can We Do","sub_title":"Services we can help you with","action_text":"See All Services","action_url":"#"},"portfolio_section":{"layout":"1","title":"Latest Projects","sub_title":"Portfolio to explore","action_text":"See Details"},"award_section":{"title":"Our Awards","sub_title":"We get multiple awards","items":[{"year":2019,"title":"Google awards","list_item":["Website of the day","Mobile exelence"]},{"year":2019,"title":"Google awards","list_item":["Website of the day","Mobile exelence"]},{"year":2019,"title":"Google awards","list_item":["Website of the day","Mobile exelence"]},{"year":2019,"title":"Google awards","list_item":["Website of the day","Mobile exelence"]},{"year":2019,"title":"Google awards","list_item":["Website of the day","Mobile exelence"]},{"year":2019,"title":"Google awards","list_item":["Website of the day","Mobile exelence"]},{"year":2019,"title":"Google awards","list_item":["Website of the day","Mobile exelence"]},{"year":2019,"title":"Google awards","list_item":["Website of the day","Mobile exelence"]}]},"video_section":{"layout":"3","title":"Our agile process is ability to adapt and respond to change. Agile organizations view change as an opportunity, not a threat.","sub_title":null,"thumbnail_image_url":"/storage/pages/rBIO5ArukegxVU6mMnYe6tpu5rSY5uBP3SqbYm1Y.webp","video_url":"https://www.youtube.com/watch?v=rIfdg_Ot-LI","action_text":"Learn more","action_url":null},"our_team_section":{"title":"Our Team","sub_title":"Awesome team member"},"testimonial_section":[],"our_blog":{"layout":"1","title":"Our Blog","sub_title":"Explore recent publication","action_text":"View More Blog"},"moving_text_section":{"text":"Our reputed world wide partners"},"partner_section":{"layout":"1","title":"Top Clients","sub_title":"Our reputed partner","logos":["/static/partner_1.svg","/static/partner_2.svg","/static/partner_3.svg","/static/partner_4.svg","/static/partner_5.svg"]},"cta_section":{"title":"Let’s disscuse make <br />something <i>cool</i> together","background_image_url":"/static/cta_bg.jpeg","action_text":"Apply For Metting","action_url":"#"},"pricing_section":{"title":"Pricing & Packaging","sub_title":"Providing best pricing for client","currency_symbol":"$","plans":[{"name":"Standard","price":{"monthly":10,"yearly":10},"features":["Static responsive website","Video marketing","Keywords research","Facebook campaign","eCommerce solution","Google adword"],"action_text":"Purchase Now","action_url":"#"},{"name":"Professional","price":{"monthly":99,"yearly":199},"features":["Static responsive website","Video marketing","Keywords research","Facebook campaign","eCommerce solution","Google adword"],"action_text":"Purchase Now","action_url":"#"},{"name":"Ultimate","price":{"monthly":199,"yearly":299},"features":["Static responsive website","Video marketing","Keywords research","Facebook campaign","eCommerce solution","Google adword"],"action_text":"Purchase Now","action_url":"#"}]},"contact_section":{"layout":"1","title":"Contact Us","sub_title":"Getting touch","action_button_text":"Send Message","map_iframe_url":"https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d96652.27317354927!2d-74.33557928194516!3d40.79756494697628!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x89c3a82f1352d0dd%3A0x81d4f72c4435aab5!2sTroy+Meadows+Wetlands!5e0!3m2!1sen!2sbd!4v1563075599994!5m2!1sen!2sbd"},"case_study_section":{"title":"Case Study","sub_title":"Featured case study"},"about_section":{"layout":"1","description":"This is the main factor that sets us apart from our competition and allows us to deliver a specialist business consultancy service. Our team applies its wide-ranging experience to determining. Through our years of experience, we’ve also learned that while each channel.","photos":["/storage/pages/xP26NlcJVxuAU0wrkyXdmdksBehs1Bve2fNX2sLa.jpg","/storage/pages/sAOIU4AxdkyhS5T0MvAFBF3yCuzKPwoZDobw22BQ.jpg","/storage/pages/m2ahPh6jheKbO0PpAUeIKrT2I1qXlA8Mpde77uw9.jpg"],"title":"About Us","sub_title":"We are UK based photography <br/>agency","action_text":"Learn More","action_url":"#","about_image":"/static/about_img_5.jpeg"},"home_sections":[{"id":"Hero","title":"Hero Section","spacing":{"top":{"lg":0,"md":0},"bottom":{"lg":0,"md":0}}},{"id":"FunFact","title":"Fun fact Section","spacing":{"top":{"lg":0,"md":0},"bottom":{"lg":0,"md":0}}},{"id":"Service","title":"Services Section","spacing":{"top":{"lg":"150","md":"80"},"bottom":{"lg":0,"md":0}}},{"id":"Portfolio","title":"Portfolio Section","spacing":{"top":{"lg":"150","md":"80"},"bottom":{"lg":0,"md":0}}},{"id":"Award","title":"Award Section","spacing":{"top":{"lg":"150","md":"80"},"bottom":{"lg":0,"md":0}}},{"id":"Video","title":"Video Section","spacing":{"top":{"lg":"130","md":"70"},"bottom":{"lg":0,"md":0}}},{"id":"Team","title":"Team Section","spacing":{"top":{"lg":"145","md":"80"},"bottom":{"lg":0,"md":0}}},{"id":"Testimonial","title":"Testimonial Section","spacing":{"top":{"lg":"150","md":"80"},"bottom":{"lg":0,"md":0}}},{"id":"Blog","title":"Blog Section","spacing":{"top":{"lg":"150","md":"80"},"bottom":{"lg":0,"md":0}}},{"id":"MovingText","title":"Moving Text Section","spacing":{"top":{"lg":"125","md":"70"},"bottom":{"lg":0,"md":0}}},{"id":"Partner","title":"Partner Section","spacing":{"top":{"lg":"105","md":"70"},"bottom":{"lg":0,"md":0}}},{"id":"CTA","title":"CTA Section","spacing":{"top":{"lg":"150","md":"80"},"bottom":{"lg":0,"md":0}}}],"why_choose_us":{"title":"Highly experienced pepole with us","sub_title":"Why Choose Us","description":"This is the main factor that sets us apart from our competition and allows us to deliver a specialist business consultancy service. Our team applies its wide-ranging experience to determining. Through our years of experience, we’ve also learned that while each channel.This is the main factor that sets us apart from our competition and allows us to deliver a specialist business consultancy service. Our team applies its wide-ranging experience to determining.","image":"/storage/pages/aXxSpBjaa1ViJu4etTncMWf0i7jQ8tmwa5Fbi3Yn.avif"},"faq_section":{"layout":"2","title":"Some pre questions and answers","sub_title":"FAQ’s","categories":[{"name":"Service related","url":"#"},{"name":"Pricing","url":"#"},{"name":"Project delivery","url":"#"},{"name":"Documentation","url":"#"}],"faqs":[{"questions":"Do you design illustration website?","answers":"At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesent voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui."},{"questions":"Do you provide design source file after finish work?","answers":"At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesent voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui."},{"questions":"How to provide project details and payments?","answers":"At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesent voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui."},{"questions":"Can you tell me please how to contact for project?","answers":"At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesent voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui."},{"questions":"Do you makes custom logo, icon etc?","answers":"At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesent voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui."}]}}']);
        Setting::create(['setting_group' => 'theme_settings', 'setting_key' => 'photography_agency_theme_data', 'setting_value' => '{"hero_section":{"layout":"2","title":"Creativity In Our Blood Line","sub_title":"We deliver best problem solving solution for our client and provide finest finishing product in present and upcoming future.","action_text":"Get a Quote","background_image_url":"\/static\/hero_bg.jpeg","action_url":"#","social_links":{"title":"Follow Us","links":[{"title":"Facebook","url":"#"},{"title":"Twitter","url":"#"},{"title":"Instagram","url":"#"}]},"email_address":"mahadicreation@gmail.com","phone_number":"01722285902","photography_slider":[{"title":"Wedding","imageUrl":"\/static\/wedding.jpeg","href":"\/service\/service-details"},{"title":"Fashion","imageUrl":"\/static\/fashion.jpeg","href":"\/service\/service-details"},{"title":"Commercial","imageUrl":"\/static\/commercial.jpeg","href":"\/service\/service-details"},{"title":"Landscape","imageUrl":"\/static\/landscape.jpeg","href":"\/service\/service-details"}]},"our_fun_fact_section":{"layout":"4","title":"Our fun fact","sub_title":"Sed ut perspiciatis unde omnis iste natus error voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis.","background_color":"linear-gradient(267.18deg, #161616 0%, #080808 100%)","fun_facts":[{"title":"Global Happy Clients","value":"40K"},{"title":"Project Completed","value":"50K"},{"title":"Team Members","value":"245"}]},"service_section":{"layout":"1","title":"What Can We Do","sub_title":"Services we can help you with","action_text":"See All Services", "action_url": "#"},"portfolio_section":{"layout":"2","title":"Latest Projects","sub_title":"Portfolio to explore","action_text":"See Details"},"award_section":{"title":"Our Awards","sub_title":"We get multiple awards","items":[{"year":2019,"title":"Google awards","list_item":["Website of the day","Mobile exelence"]},{"year":2019,"title":"Google awards","list_item":["Website of the day","Mobile exelence"]},{"year":2019,"title":"Google awards","list_item":["Website of the day","Mobile exelence"]},{"year":2019,"title":"Google awards","list_item":["Website of the day","Mobile exelence"]},{"year":2019,"title":"Google awards","list_item":["Website of the day","Mobile exelence"]},{"year":2019,"title":"Google awards","list_item":["Website of the day","Mobile exelence"]},{"year":2019,"title":"Google awards","list_item":["Website of the day","Mobile exelence"]},{"year":2019,"title":"Google awards","list_item":["Website of the day","Mobile exelence"]}]},"video_section":{"layout":"1","title":"Our agile process is ability to adapt and respond to change. Agile organizations view change as an opportunity, not a threat.","sub_title":null,"thumbnail_image_url":"\/static\/video_bg.jpeg","video_url":"https:\/\/www.youtube.com\/watch?v=rIfdg_Ot-LI","action_text":"Learn more","action_url":null},"our_team_section":{"title":"Our Team","sub_title":"Awesome team member"},"testimonial_section":[],"our_blog":{"layout":"1","title":"Our Blog","sub_title":"Explore recent publication","action_text":"View More Blog"},"moving_text_section":{"text":"Our reputed world wide partners"},"partner_section":{"layout":"1","title":"Top Clients","sub_title":"Our reputed partner","logos":["\/static\/partner_1.svg","\/static\/partner_2.svg","\/static\/partner_3.svg","\/static\/partner_4.svg","\/static\/partner_5.svg"]},"cta_section":{"title":"Let\u2019s disscuse make <br \/>something <i>cool<\/i> together","background_image_url":"\/static\/cta_bg.jpeg","action_text":"Apply For Metting","action_url":"#"},"pricing_section":{"title":"Pricing & Packaging","sub_title":"Providing best pricing for client","currency_symbol":"$","plans":[{"name":"Standard","price":{"monthly":10,"yearly":10},"features":["Static responsive website","Video marketing","Keywords research","Facebook campaign","eCommerce solution","Google adword"],"action_text":"Purchase Now","action_url":"#"},{"name":"Professional","price":{"monthly":99,"yearly":199},"features":["Static responsive website","Video marketing","Keywords research","Facebook campaign","eCommerce solution","Google adword"],"action_text":"Purchase Now","action_url":"#"},{"name":"Ultimate","price":{"monthly":199,"yearly":299},"features":["Static responsive website","Video marketing","Keywords research","Facebook campaign","eCommerce solution","Google adword"],"action_text":"Purchase Now","action_url":"#"}]},"contact_section":{"layout":"1","title":"Contact Us","sub_title":"Getting touch","action_button_text":"Send Message","map_iframe_url":"https:\/\/www.google.com\/maps\/embed?pb=!1m18!1m12!1m3!1d96652.27317354927!2d-74.33557928194516!3d40.79756494697628!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x89c3a82f1352d0dd%3A0x81d4f72c4435aab5!2sTroy+Meadows+Wetlands!5e0!3m2!1sen!2sbd!4v1563075599994!5m2!1sen!2sbd"},"case_study_section":{"title":"Case Study","sub_title":"Featured case study"},"about_section":{"layout":"1","description":"This is the main factor that sets us apart from our competition and allows us to deliver a specialist business consultancy service. Our team applies its wide-ranging experience to determining. Through our years of experience, we\u2019ve also learned that while each channel.","photos":["\/storage\/pages\/xP26NlcJVxuAU0wrkyXdmdksBehs1Bve2fNX2sLa.jpg","\/storage\/pages\/sAOIU4AxdkyhS5T0MvAFBF3yCuzKPwoZDobw22BQ.jpg","\/storage\/pages\/m2ahPh6jheKbO0PpAUeIKrT2I1qXlA8Mpde77uw9.jpg"],"title":"About Us","sub_title":"We are UK based photography <br\/>agency","action_text":"Learn More","action_url":"#","about_image":"\/static\/about_img_5.jpeg"},"home_sections":[{"id":"Hero","title":"Hero Section","spacing":{"top":{"lg":0,"md":0},"bottom":{"lg":0,"md":0}}},{"id":"About","title":"About Section","spacing":{"top":{"lg":"150","md":"80"},"bottom":{"lg":0,"md":0}}},{"id":"Service","title":"Services Section","spacing":{"top":{"lg":"150","md":"80"},"bottom":{"lg":0,"md":0}}},{"id":"Portfolio","title":"Portfolio Section","spacing":{"top":{"lg":"145","md":"80"},"bottom":{"lg":0,"md":0}}},{"id":"Pricing","title":"Pricing Section","spacing":{"top":{"lg":"140","md":"70"},"bottom":{"lg":"125","md":"55"}}},{"id":"Testimonial","title":"Testimonial Section","spacing":{"top":{"lg":0,"md":0},"bottom":{"lg":0,"md":0}}},{"id":"Blog","title":"Blog Section","spacing":{"top":{"lg":"150","md":"80"},"bottom":{"lg":null,"md":null}}},{"id":"FunFact","title":"Fun fact Section","spacing":{"top":{"lg":"140","md":"80"},"bottom":{"lg":"0","md":"0"}}},{"id":"Contact","title":"Google Map","spacing":{"top":{"lg":"140","md":"70"},"bottom":{"lg":0,"md":0}}}],"why_choose_us":{"title":"Highly experienced pepole with us","sub_title":"Why Choose Us","description":"This is the main factor that sets us apart from our competition and allows us to deliver a specialist business consultancy service. Our team applies its wide-ranging experience to determining. Through our years of experience, we\u2019ve also learned that while each channel.This is the main factor that sets us apart from our competition and allows us to deliver a specialist business consultancy service. Our team applies its wide-ranging experience to determining.","image":null},"faq_section":{"layout":"2","title":"Some pre questions and answers","sub_title":"FAQ\u2019s","categories":[{"name":"Service related","url":"#"},{"name":"Pricing","url":"#"},{"name":"Project delivery","url":"#"},{"name":"Documentation","url":"#"}],"faqs":[{"questions":"Do you design illustration website?","answers":"At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesent voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui."},{"questions":"Do you provide design source file after finish work?","answers":"At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesent voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui."},{"questions":"How to provide project details and payments?","answers":"At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesent voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui."},{"questions":"Can you tell me please how to contact for project?","answers":"At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesent voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui."},{"questions":"Do you makes custom logo, icon etc?","answers":"At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesent voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui."}]}}']);
        Setting::create(['setting_group' => 'theme_settings', 'setting_key' => 'creative_portfolio_theme_data', 'setting_value' => '{"hero_section":{"layout":"3","title":"Arino Creative Portfolio","sub_title":"We deliver best problem solving solution for our client and provide finest finishing product in present and upcoming future.","action_text":"Lets talk","background_image_url":"/static/hero_bg.jpeg","action_url":"#","social_links":{"title":"Follow Us","links":[{"title":"Facebook","url":"#"},{"title":"Twitter","url":"#"}]},"email_address":"mahadicreation@gmail.com","phone_number":"01722285902","photography_slider":[{"title":"Wedding","imageUrl":"/static/wedding.jpeg","href":"/service/service-details"},{"title":"Fashion","imageUrl":"/static/fashion.jpeg","href":"/service/service-details"},{"title":"Commercial","imageUrl":"/static/commercial.jpeg","href":"/service/service-details"},{"title":"Landscape","imageUrl":"/static/landscape.jpeg","href":"/service/service-details"}]},"our_fun_fact_section":{"layout":"4","title":"Our fun fact","sub_title":"Sed ut perspiciatis unde omnis iste natus error voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis.","background_color":"linear-gradient(267.18deg, #161616 0%, #080808 100%)","fun_facts":[{"title":"Global Happy Clients","value":"40K"},{"title":"Project Completed","value":"50K"},{"title":"Team Members","value":"245"},{"title":"Digital products","value":"550"}]},"service_section":{"layout":"1","title":"What Can We Do","sub_title":"Services we can help you with","action_text":"See All Services"},"portfolio_section":{"layout":"5","title":"Latest Projects","sub_title":"Portfolio to explore","action_text":"See Details","action_url":"#"},"award_section":{"title":"Our Awards","sub_title":"We get multiple awards","background_color":"#181818","items":[{"year":2019,"title":"Google awards","list_item":["Website of the day","Mobile exelence"]},{"year":2019,"title":"Google awards","list_item":["Website of the day","Mobile exelence"]},{"year":2019,"title":"Google awards","list_item":["Website of the day","Mobile exelence"]},{"year":2019,"title":"Google awards","list_item":["Website of the day","Mobile exelence"]},{"year":2019,"title":"Google awards","list_item":["Website of the day","Mobile exelence"]},{"year":2019,"title":"Google awards","list_item":["Website of the day","Mobile exelence"]},{"year":2019,"title":"Google awards","list_item":["Website of the day","Mobile exelence"]},{"year":2019,"title":"Google awards","list_item":["Website of the day","Mobile exelence"]}]},"video_section":{"layout":"1","title":"Our agile process is ability to adapt and respond to change. Agile organizations view change as an opportunity, not a threat.","sub_title":null,"thumbnail_image_url":"/static/video_bg.jpeg","video_url":"https://www.youtube.com/watch?v=rIfdg_Ot-LI","action_text":"Learn more","action_url":null},"our_team_section":{"title":"Our Team","sub_title":"Awesome team member"},"testimonial_section":[],"our_blog":{"layout":"1","title":"Our Blog","sub_title":"Explore recent publication","action_text":"View More Blog"},"moving_text_section":{"text":"Our reputed world wide partners"},"partner_section":{"layout":"1","title":"Top Clients","sub_title":"Our reputed partner","logos":["/static/partner_1.svg","/static/partner_2.svg","/static/partner_3.svg","/static/partner_4.svg","/static/partner_5.svg"]},"cta_section":{"title":"Let’s disscuse make <br />something <i>cool</i> together","background_image_url":"/static/cta_bg_3.jpeg","action_text":"Apply For Metting","action_url":"#"},"pricing_section":{"title":"Pricing & Packaging","sub_title":"Providing best pricing for client","currency_symbol":"$","plans":[{"name":"Standard","price":{"monthly":10,"yearly":10},"features":["Static responsive website","Video marketing","Keywords research","Facebook campaign","eCommerce solution","Google adword"],"action_text":"Purchase Now","action_url":"#"},{"name":"Professional","price":{"monthly":99,"yearly":199},"features":["Static responsive website","Video marketing","Keywords research","Facebook campaign","eCommerce solution","Google adword"],"action_text":"Purchase Now","action_url":"#"},{"name":"Ultimate","price":{"monthly":199,"yearly":299},"features":["Static responsive website","Video marketing","Keywords research","Facebook campaign","eCommerce solution","Google adword"],"action_text":"Purchase Now","action_url":"#"}]},"contact_section":{"layout":"1","title":"Contact Us","sub_title":"Getting touch","action_button_text":"Send Message","map_iframe_url":"https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d96652.27317354927!2d-74.33557928194516!3d40.79756494697628!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x89c3a82f1352d0dd%3A0x81d4f72c4435aab5!2sTroy+Meadows+Wetlands!5e0!3m2!1sen!2sbd!4v1563075599994!5m2!1sen!2sbd"},"case_study_section":{"title":"Case Study","sub_title":"Featured case study"},"about_section":{"layout":"1","description":"This is the main factor that sets us apart from our competition and allows us to deliver a specialist business consultancy service. Our team applies its wide-ranging experience to determining. Through our years of experience, we’ve also learned that while each channel.","photos":["/storage/pages/xP26NlcJVxuAU0wrkyXdmdksBehs1Bve2fNX2sLa.jpg","/storage/pages/sAOIU4AxdkyhS5T0MvAFBF3yCuzKPwoZDobw22BQ.jpg","/storage/pages/m2ahPh6jheKbO0PpAUeIKrT2I1qXlA8Mpde77uw9.jpg"],"title":"About Us","sub_title":"We are UK based photography <br/>agency","action_text":"Learn More","action_url":"#","about_image":"/static/about_img_5.jpeg"},"home_sections":[{"id":"Hero","title":"Hero Section","spacing":{"top":{"lg":0,"md":0},"bottom":{"lg":0,"md":0}}},{"id":"Portfolio","title":"Portfolio Section","spacing":{"top":{"lg":"150","md":"80"},"bottom":{"lg":0,"md":0}}},{"id":"CaseStudy","title":"Case Study Section","spacing":{"top":{"lg":"45","md":"10"},"bottom":{"lg":0,"md":0}}},{"id":"Testimonial","title":"Testimonial Section","spacing":{"top":{"lg":"150","md":"80"},"bottom":{"lg":0,"md":0}}},{"id":"MovingText","title":"Moving Text Section","spacing":{"top":{"lg":"125","md":"70"},"bottom":{"lg":0,"md":0}}},{"id":"Partner","title":"Partner Section","spacing":{"top":{"lg":"105","md":"70"},"bottom":{"lg":0,"md":0}}},{"id":"CTA","title":"CTA Section","spacing":{"top":{"lg":"150","md":"80"},"bottom":{"lg":0,"md":0}}}],"why_choose_us":{"title":"Highly experienced pepole with us","sub_title":"Why Choose Us","description":"This is the main factor that sets us apart from our competition and allows us to deliver a specialist business consultancy service. Our team applies its wide-ranging experience to determining. Through our years of experience, we’ve also learned that while each channel.This is the main factor that sets us apart from our competition and allows us to deliver a specialist business consultancy service. Our team applies its wide-ranging experience to determining.","image":null},"faq_section":{"layout":"2","title":"Some pre questions and answers","sub_title":"FAQ’s","categories":[{"name":"Service related","url":"#"},{"name":"Pricing","url":"#"},{"name":"Project delivery","url":"#"},{"name":"Documentation","url":"#"}],"faqs":[{"questions":"Do you design illustration website?","answers":"At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesent voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui."},{"questions":"Do you provide design source file after finish work?","answers":"At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesent voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui."},{"questions":"How to provide project details and payments?","answers":"At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesent voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui."},{"questions":"Can you tell me please how to contact for project?","answers":"At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesent voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui."},{"questions":"Do you makes custom logo, icon etc?","answers":"At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesent voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui."}]}}']);
        Setting::create(['setting_group' => 'theme_settings', 'setting_key' => 'digital_agency_theme_data', 'setting_value' => '{"hero_section":{"layout":"4","title":"We Are Arino Digital Agency","sub_title":"We deliver best problem solving solution for our client and provide finest finishing product in present and upcoming future.","action_text":"Lets talk","background_image_url":"/static/hero_bg_3.jpeg","action_url":"#","social_links":{"title":"Follow Us","links":[{"title":"Facebook","url":"#"},{"title":"Twitter","url":"#"},{"title":"Instagram","url":"#"}]},"email_address":"mahadicreation@gmail.com","phone_number":"01722285902","photography_slider":[{"title":"Wedding","imageUrl":"/static/wedding.jpeg","href":"/service/service-details"},{"title":"Fashion","imageUrl":"/static/fashion.jpeg","href":"/service/service-details"},{"title":"Commercial","imageUrl":"/static/commercial.jpeg","href":"/service/service-details"},{"title":"Landscape","imageUrl":"/static/landscape.jpeg","href":"/service/service-details"}]},"our_fun_fact_section":{"layout":"2","title":"Our fun fact","sub_title":"Sed ut perspiciatis unde omnis iste natus error voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis.","background_color":"linear-gradient(267.18deg, #161616 0%, #080808 100%)","fun_facts":[{"title":"Global Happy Clients","value":"40K"},{"title":"Project Completed","value":"50K"},{"title":"Team Members","value":"245"},{"title":"Digital products","value":"550"}]},"service_section":{"layout":"3","title":"What Can We Do","sub_title":"Services we can help you with","action_text":"See All Services"},"portfolio_section":{"layout":"4","title":"Latest Projects","sub_title":"Portfolio to explore","action_text":"See Details","action_url":"#"},"award_section":{"title":"Our Awards","sub_title":"We get multiple awards","items":[{"year":2019,"title":"Google awards","list_item":["Website of the day","Mobile exelence"]},{"year":2019,"title":"Google awards","list_item":["Website of the day","Mobile exelence"]},{"year":2019,"title":"Google awards","list_item":["Website of the day","Mobile exelence"]},{"year":2019,"title":"Google awards","list_item":["Website of the day","Mobile exelence"]},{"year":2019,"title":"Google awards","list_item":["Website of the day","Mobile exelence"]},{"year":2019,"title":"Google awards","list_item":["Website of the day","Mobile exelence"]},{"year":2019,"title":"Google awards","list_item":["Website of the day","Mobile exelence"]},{"year":2019,"title":"Google awards","list_item":["Website of the day","Mobile exelence"]}]},"video_section":{"layout":"1","title":"Why Choose Us","sub_title":"Uk’s best digital agency ever","thumbnail_image_url":"/static/video_bg.jpeg","video_url":"https://www.youtube.com/watch?v=rIfdg_Ot-LI","action_text":"Learn more","action_url":null},"our_team_section":{"title":"Our Team","sub_title":"Awesome team member"},"testimonial_section":[],"our_blog":{"layout":"2","title":"Our Blog","sub_title":"Explore recent publication","action_text":"View More Blog"},"moving_text_section":{"text":"Our reputed world wide partners"},"partner_section":{"layout":"2","title":"Top Clients","sub_title":"Our reputed partner","logos":["/static/partner_1.svg","/static/partner_2.svg","/static/partner_3.svg","/static/partner_4.svg","/static/partner_5.svg"]},"cta_section":{"title":"Let’s disscuse make <br />something <i>cool</i> together","background_image_url":"/static/cta_bg.jpeg","action_text":"Apply For Metting","action_url":"#"},"pricing_section":{"title":"Pricing & Packaging","sub_title":"Providing best pricing for client","currency_symbol":"$","plans":[{"name":"Standard","price":{"monthly":10,"yearly":10},"features":["Static responsive website","Video marketing","Keywords research","Facebook campaign","eCommerce solution","Google adword"],"action_text":"Purchase Now","action_url":"#"},{"name":"Professional","price":{"monthly":99,"yearly":199},"features":["Static responsive website","Video marketing","Keywords research","Facebook campaign","eCommerce solution","Google adword"],"action_text":"Purchase Now","action_url":"#"},{"name":"Ultimate","price":{"monthly":199,"yearly":299},"features":["Static responsive website","Video marketing","Keywords research","Facebook campaign","eCommerce solution","Google adword"],"action_text":"Purchase Now","action_url":"#"}]},"contact_section":{"layout":"1","title":"Contact Us","sub_title":"Getting touch","action_button_text":"Send Message","map_iframe_url":"https://www.google.com/maps/embed?pb=!1m14!1m12!1m3!1d29520.8871222201!2d90.3344973!3d22.349441399999996!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!5e0!3m2!1sen!2sbd!4v1691222409957!5m2!1sen!2sbd"},"case_study_section":{"title":"Case Study","sub_title":"Featured case study"},"about_section":{"layout":"1","description":"This is the main factor that sets us apart from our competition and allows us to deliver a specialist business consultancy service. Our team applies its wide-ranging experience to determining. Through our years of experience, we’ve also learned that while each channel.","photos":["/storage/pages/xP26NlcJVxuAU0wrkyXdmdksBehs1Bve2fNX2sLa.jpg","/storage/pages/sAOIU4AxdkyhS5T0MvAFBF3yCuzKPwoZDobw22BQ.jpg","/storage/pages/m2ahPh6jheKbO0PpAUeIKrT2I1qXlA8Mpde77uw9.jpg"],"title":"About Us","sub_title":"We are UK based photography <br/>agency","action_text":"Learn More","action_url":"#","about_image":"/static/about_img_5.jpeg"},"home_sections":[{"id":"Hero","title":"Hero Section","spacing":{"top":{"lg":0,"md":0},"bottom":{"lg":0,"md":0}}},{"id":"FunFact","title":"Fun fact Section","spacing":{"top":{"lg":0,"md":0},"bottom":{"lg":0,"md":0}}},{"id":"Service","title":"Service Section","spacing":{"top":{"lg":"145","md":"80"},"bottom":{"lg":0,"md":0}}},{"id":"Video","title":"Video Section","spacing":{"top":{"lg":"150","md":"80"},"bottom":{"lg":0,"md":0}}},{"id":"Portfolio","title":"Portfolio Section","spacing":{"top":{"lg":"145","md":"80"},"bottom":{"lg":0,"md":0}}},{"id":"Award","title":"Award Section","spacing":{"top":{"lg":"140","md":"80"},"bottom":{"lg":0,"md":0}}},{"id":"Testimonial","title":"Testimonial Section","spacing":{"top":{"lg":0,"md":0},"bottom":{"lg":0,"md":0}}},{"id":"Blog","title":"Blog Section","spacing":{"top":{"lg":0,"md":0},"bottom":{"lg":0,"md":0}}},{"id":"Partner","title":"Partner Section","spacing":{"top":{"lg":"145","md":"80"},"bottom":{"lg":0,"md":0}}},{"id":"CTA","title":"CTA Section","spacing":{"top":{"lg":"150","md":"80"},"bottom":{"lg":0,"md":0}}}],"why_choose_us":{"title":"Highly experienced pepole with us","sub_title":"Why Choose Us","description":"This is the main factor that sets us apart from our competition and allows us to deliver a specialist business consultancy service. Our team applies its wide-ranging experience to determining. Through our years of experience, we’ve also learned that while each channel.This is the main factor that sets us apart from our competition and allows us to deliver a specialist business consultancy service. Our team applies its wide-ranging experience to determining.","image":null},"faq_section":{"layout":"2","title":"Some pre questions and answers","sub_title":"FAQ’s","categories":[{"name":"Service related","url":"#"},{"name":"Pricing","url":"#"},{"name":"Project delivery","url":"#"},{"name":"Documentation","url":"#"}],"faqs":[{"questions":"Do you design illustration website?","answers":"At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesent voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui."},{"questions":"Do you provide design source file after finish work?","answers":"At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesent voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui."},{"questions":"How to provide project details and payments?","answers":"At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesent voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui."},{"questions":"Can you tell me please how to contact for project?","answers":"At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesent voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui."},{"questions":"Do you makes custom logo, icon etc?","answers":"At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesent voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui."}]}}']);
        Setting::create(['setting_group' => 'theme_settings', 'setting_key' => 'marketing_agency_theme_data', 'setting_value' => '{"hero_section":{"layout":"5","title":"Grow Your Business With Digital Strategy","sub_title":"We deliver best problem solving solution for our client and provide finest finishing product in present and upcoming future.","action_text":"Lets talk","background_image_url":"/static/hero_bg_3.jpeg","action_url":"#","social_links":{"title":"Follow Us","links":[{"title":"Facebook","url":"#"},{"title":"Twitter","url":"#"}]},"email_address":"mahadicreation@gmail.com","phone_number":"01722285902","photography_slider":[{"title":"Wedding","imageUrl":"/static/wedding.jpeg","href":"/service/service-details"},{"title":"Fashion","imageUrl":"/static/fashion.jpeg","href":"/service/service-details"},{"title":"Commercial","imageUrl":"/static/commercial.jpeg","href":"/service/service-details"},{"title":"Landscape","imageUrl":"/static/landscape.jpeg","href":"/service/service-details"}]},"our_fun_fact_section":{"layout":"2","title":"Our fun fact","sub_title":"Sed ut perspiciatis unde omnis iste natus error voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis.","background_color":"linear-gradient(267.18deg, #161616 0%, #080808 100%)","fun_facts":[{"title":"Global Happy Clients","value":"40K"},{"title":"Project Completed","value":"50K"},{"title":"Team Members","value":"245"},{"title":"Digital products","value":"550"}]},"service_section":{"layout":"2","title":"Services","sub_title":"Our core services","action_text":"See All Services","action_url":"#"},"portfolio_section":{"layout":"3","title":"Our agile process is ability to adapt and respond to change. We work with love and joyfull together. Check our case study and portfolio.","sub_title":"Portfolio to explore","action_text":"See Details"},"award_section":{"title":"Our Awards","sub_title":"We get multiple awards","background_color":"#181818","items":[{"year":2019,"title":"Google awards","list_item":["Website of the day","Mobile exelence"]},{"year":2019,"title":"Google awards","list_item":["Website of the day","Mobile exelence"]},{"year":2019,"title":"Google awards","list_item":["Website of the day","Mobile exelence"]},{"year":2019,"title":"Google awards","list_item":["Website of the day","Mobile exelence"]},{"year":2019,"title":"Google awards","list_item":["Website of the day","Mobile exelence"]},{"year":2019,"title":"Google awards","list_item":["Website of the day","Mobile exelence"]},{"year":2019,"title":"Google awards","list_item":["Website of the day","Mobile exelence"]},{"year":2019,"title":"Google awards","list_item":["Website of the day","Mobile exelence"]}]},"video_section":{"layout":"3","title":"Why Choose Us","sub_title":"Uk’s best digital agency ever","thumbnail_image_url":"/static/video_bg_2.jpeg","video_url":"https://www.youtube.com/watch?v=rIfdg_Ot-LI","action_text":"Learn more","action_url":null},"our_team_section":{"title":"Our Team","sub_title":"Awesome team member"},"testimonial_section":[],"our_blog":{"layout":"1","title":"Our Blog","sub_title":"Explore recent publication","action_text":"View More Blog"},"moving_text_section":{"text":"Our reputed world wide partners"},"partner_section":{"layout":"1","title":"Top Clients","sub_title":"Our reputed partner","logos":["/static/partner_1.svg","/static/partner_2.svg","/static/partner_3.svg","/static/partner_4.svg","/static/partner_5.svg"]},"cta_section":{"title":"Let’s disscuse make <br />something <i>cool</i> together","background_image_url":"/static/cta_bg_3.jpeg","action_text":"Apply For Metting","action_url":"#"},"pricing_section":{"title":"Pricing & Packaging","sub_title":"Providing best pricing for client","currency_symbol":"$","plans":[{"name":"Standard","price":{"monthly":10,"yearly":10},"features":["Static responsive website","Video marketing","Keywords research","Facebook campaign","eCommerce solution","Google adword"],"action_text":"Purchase Now","action_url":"#"},{"name":"Professional","price":{"monthly":99,"yearly":199},"features":["Static responsive website","Video marketing","Keywords research","Facebook campaign","eCommerce solution","Google adword"],"action_text":"Purchase Now","action_url":"#"},{"name":"Ultimate","price":{"monthly":199,"yearly":299},"features":["Static responsive website","Video marketing","Keywords research","Facebook campaign","eCommerce solution","Google adword"],"action_text":"Purchase Now","action_url":"#"}]},"contact_section":{"layout":"1","title":"Contact Us","sub_title":"Getting touch","action_button_text":"Send Message","map_iframe_url":"https://www.google.com/maps/embed?pb=!1m14!1m12!1m3!1d29520.8871222201!2d90.3344973!3d22.349441399999996!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!5e0!3m2!1sen!2sbd!4v1691222409957!5m2!1sen!2sbd"},"case_study_section":{"title":"Case Study","sub_title":"Featured case study"},"about_section":{"layout":"1","description":"This is the main factor that sets us apart from our competition and allows us to deliver a specialist business consultancy service. Our team applies its wide-ranging experience to determining. Through our years of experience, we’ve also learned that while each channel.","photos":["/storage/pages/xP26NlcJVxuAU0wrkyXdmdksBehs1Bve2fNX2sLa.jpg","/storage/pages/sAOIU4AxdkyhS5T0MvAFBF3yCuzKPwoZDobw22BQ.jpg","/storage/pages/m2ahPh6jheKbO0PpAUeIKrT2I1qXlA8Mpde77uw9.jpg"],"title":"About Us","sub_title":"We are UK based photography <br/>agency","action_text":"Learn More","action_url":"#","about_image":"/static/about_img_5.jpeg"},"home_sections":[{"id":"Hero","title":"Hero Section","spacing":{"top":{"lg":0,"md":0},"bottom":{"lg":0,"md":0}}},{"id":"Video","title":"Video Section","spacing":{"top":{"lg":"0","md":"0"},"bottom":{"lg":0,"md":0}}},{"id":"Service","title":"Service Section","spacing":{"top":{"lg":"145","md":"80"},"bottom":{"lg":0,"md":0}}},{"id":"Portfolio","title":"Portfolio Section","spacing":{"top":{"lg":"120","md":"50"},"bottom":{"lg":0,"md":0}}},{"id":"FunFact","title":"Fun fact Section","spacing":{"top":{"lg":"150","md":"80"},"bottom":{"lg":0,"md":0}}},{"id":"Pricing","title":"Pricing Section","spacing":{"top":{"lg":"145","md":"80"},"bottom":{"lg":0,"md":0}}},{"id":"Testimonial","title":"Testimonial Section","spacing":{"top":{"lg":"125","md":"55"},"bottom":{"lg":0,"md":0}}},{"id":"Blog","title":"Blog Section","spacing":{"top":{"lg":"150","md":"80"},"bottom":{"lg":0,"md":0}}},{"id":"MovingText","title":"Moving Text Section","spacing":{"top":{"lg":"125","md":"70"},"bottom":{"lg":0,"md":0}}},{"id":"Partner","title":"Partner Section","spacing":{"top":{"lg":"100","md":"70"},"bottom":{"lg":0,"md":0}}},{"id":"CTA","title":"CTA Section","spacing":{"top":{"lg":"130","md":"80"},"bottom":{"lg":0,"md":0}}}],"why_choose_us":{"title":"Highly experienced pepole with us","sub_title":"Why Choose Us","description":"This is the main factor that sets us apart from our competition and allows us to deliver a specialist business consultancy service. Our team applies its wide-ranging experience to determining. Through our years of experience, we’ve also learned that while each channel.This is the main factor that sets us apart from our competition and allows us to deliver a specialist business consultancy service. Our team applies its wide-ranging experience to determining.","image":null},"faq_section":{"layout":"2","title":"Some pre questions and answers","sub_title":"FAQ’s","categories":[{"name":"Service related","url":"#"},{"name":"Pricing","url":"#"},{"name":"Project delivery","url":"#"},{"name":"Documentation","url":"#"}],"faqs":[{"questions":"Do you design illustration website?","answers":"At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesent voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui."},{"questions":"Do you provide design source file after finish work?","answers":"At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesent voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui."},{"questions":"How to provide project details and payments?","answers":"At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesent voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui."},{"questions":"Can you tell me please how to contact for project?","answers":"At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesent voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui."},{"questions":"Do you makes custom logo, icon etc?","answers":"At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesent voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui."}]}}']);

        // menu setting
        Setting::create(['setting_group' => 'menu_settings', 'setting_key' => 'main_menu', 'setting_value' => '[]']);
        Setting::create(['setting_group' => 'menu_settings', 'setting_key' => 'services_menu', 'setting_value' => '[]']);
        Setting::create(['setting_group' => 'menu_settings', 'setting_key' => 'footer_menu', 'setting_value' => '[]']);
    }
}
