import NavigationLink from "@/Components/NavigationLink"

export default function Service4({ data }) {
    const { section_image_url, section_title, section_subtitle, service_list } = data
    return (
        <div className="container">
            {(section_subtitle || section_title) && (
                <>
                    <div className="cs_section_heading cs_style_1 text-center">
                        {section_subtitle && (
                            <p
                                className="cs_section_subtitle cs_fs_18 cs_medium"
                                dangerouslySetInnerHTML={{
                                    __html: section_subtitle
                                }}
                            />
                        )}
                        {section_title && (
                            <h2
                                className="cs_section_title cs_fs_53 cs_normal mb-0"
                                dangerouslySetInnerHTML={{
                                    __html: section_title
                                }}
                            />
                        )}
                    </div>
                    <div className="cs_height_85 cs_height_lg_50" />
                </>
            )}
            <div>
                <div className="row align-items-center cs_gap_y_50">
                    <div className="col-xl-4 col-lg-5">
                        <ul className="cs_list cs_style_2 cs_mp0">
                            {service_list?.map((item, index) => (
                                <li key={index}>
                                    {(item.service_title || item.service_btn_url) && (
                                        <NavigationLink href={item.service_btn_url} className="cs_btn cs_style_1 cs_type_2">
                                            <h2
                                                className="mb-0 cs_fs_30 cs_normal"
                                                dangerouslySetInnerHTML={{
                                                    __html: item.service_title
                                                }}
                                            />
                                            <span>
                                                <i>
                                                    <svg width={11} height={11} viewBox="0 0 11 11" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                        <path
                                                            d="M1 10L10 1M10 1L1 1M10 1L10 10"
                                                            stroke="currentColor"
                                                            strokeWidth="1.5"
                                                            strokeLinecap="round"
                                                            strokeLinejoin="round"
                                                        />
                                                    </svg>
                                                </i>
                                                <i>
                                                    <svg width={11} height={11} viewBox="0 0 11 11" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                        <path
                                                            d="M1 10L10 1M10 1L1 1M10 1L10 10"
                                                            stroke="currentColor"
                                                            strokeWidth="1.5"
                                                            strokeLinecap="round"
                                                            strokeLinejoin="round"
                                                        />
                                                    </svg>
                                                </i>
                                            </span>
                                        </NavigationLink>
                                    )}
                                </li>
                            ))}
                        </ul>
                    </div>
                    <div className="col-lg-7 offset-xl-1">
                        <div className="cs_image_card cs_style_1">
                            {section_image_url && <img src={section_image_url} alt="Service" className="w-100" />}

                            <svg
                                className="cs_accent_color"
                                width={143}
                                height={135}
                                viewBox="0 0 143 135"
                                fill="none"
                                xmlns="http://www.w3.org/2000/svg"
                            >
                                <mask
                                    id="mask0_714_1022"
                                    style={{ maskType: "luminance" }}
                                    maskUnits="userSpaceOnUse"
                                    x={0}
                                    y={0}
                                    width={143}
                                    height={135}
                                >
                                    <path d="M0 0H143V135H0V0Z" fill="white" />
                                </mask>
                                <g mask="url(#mask0_714_1022)">
                                    <path
                                        d="M6.1091 131.954C6.10959 132.557 5.93069 133.147 5.59506 133.649C5.25943 134.15 4.78218 134.541 4.22375 134.772C3.66533 135.003 3.05087 135.063 2.45821 134.945C1.86555 134.827 1.32136 134.535 0.894583 134.108C0.322006 133.537 0.000220699 132.762 1.93333e-06 131.954C-0.000908395 131.142 0.319692 130.362 0.891946 129.785C1.4642 129.208 2.24173 128.88 3.0551 128.873C3.86765 128.883 4.64372 129.211 5.2153 129.788C5.78688 130.365 6.10799 131.143 6.1091 131.954ZM25.6635 131.954C25.6572 132.555 25.4726 133.141 25.1331 133.638C24.7936 134.134 24.3143 134.519 23.7557 134.745C23.1969 134.97 22.584 135.025 21.9937 134.904C21.4035 134.782 20.8623 134.49 20.4379 134.063C20.0134 133.636 19.7252 133.093 19.6097 132.502C19.4942 131.911 19.5565 131.3 19.7889 130.745C20.0212 130.189 20.4131 129.715 20.9151 129.382C21.4171 129.049 22.0067 128.872 22.6095 128.873C23.0135 128.873 23.4135 128.953 23.7864 129.108C24.1593 129.264 24.4977 129.491 24.7822 129.777C25.0662 130.064 25.2902 130.404 25.4415 130.777C25.5928 131.151 25.6683 131.551 25.6635 131.954ZM45.219 131.954C45.2127 132.555 45.0281 133.141 44.6886 133.638C44.3491 134.134 43.8698 134.519 43.3113 134.745C42.7524 134.97 42.1395 135.025 41.5493 134.904C40.9591 134.782 40.4178 134.49 39.9934 134.063C39.4955 133.563 39.187 132.905 39.1204 132.203C39.0539 131.501 39.2334 130.797 39.6285 130.213C40.0235 129.628 40.6096 129.198 41.2867 128.997C41.9637 128.795 42.6899 128.834 43.3412 129.108C43.7136 129.264 44.0515 129.491 44.3355 129.778C44.6195 130.064 44.8441 130.404 44.9962 130.778C45.1481 131.15 45.2235 131.55 45.219 131.954ZM64.779 131.954C64.7743 132.404 64.6699 132.847 64.4732 133.252C64.2765 133.656 63.9924 134.013 63.6414 134.295C63.2904 134.577 62.8811 134.778 62.443 134.884C62.0049 134.989 61.5488 134.996 61.1076 134.905C60.518 134.783 59.9776 134.49 59.5541 134.062C59.1306 133.635 58.8427 133.092 58.7264 132.503C58.6402 132.061 58.6529 131.606 58.7637 131.171C58.8744 130.735 59.0805 130.329 59.367 129.982C59.6536 129.635 60.0135 129.355 60.421 129.164C60.8285 128.972 61.2734 128.873 61.7239 128.873C62.1279 128.873 62.5279 128.953 62.9008 129.108C63.2737 129.264 63.6121 129.491 63.8966 129.777C64.1807 130.064 64.4049 130.404 64.5564 130.777C64.7079 131.151 64.7835 131.551 64.779 131.954ZM84.3334 131.954C84.3269 132.555 84.1423 133.141 83.8028 133.637C83.4633 134.134 82.9841 134.519 82.4257 134.745C81.8668 134.97 81.2539 135.025 80.6637 134.904C80.0734 134.782 79.5322 134.49 79.1078 134.063C78.6833 133.636 78.3951 133.093 78.2796 132.502C78.1641 131.911 78.2265 131.3 78.4588 130.745C78.6911 130.189 79.083 129.715 79.585 129.382C80.087 129.049 80.6766 128.872 81.2794 128.873C81.6832 128.873 82.083 128.953 82.4557 129.109C82.8284 129.264 83.1667 129.491 83.451 129.777C83.735 130.064 83.9593 130.404 84.1107 130.777C84.2622 131.151 84.3379 131.551 84.3334 131.954ZM103.889 131.954C103.883 132.555 103.698 133.141 103.358 133.638C103.018 134.135 102.539 134.52 101.98 134.745C101.421 134.969 100.809 135.025 100.219 134.903C99.6287 134.782 99.0876 134.49 98.6634 134.063C98.2389 133.636 97.9508 133.093 97.8352 132.502C97.7197 131.912 97.7819 131.3 98.0141 130.745C98.2463 130.19 98.638 129.716 99.1399 129.383C99.6417 129.05 100.231 128.872 100.834 128.873C101.238 128.873 101.638 128.953 102.011 129.108C102.384 129.264 102.722 129.491 103.007 129.777C103.291 130.064 103.515 130.404 103.666 130.777C103.818 131.151 103.894 131.551 103.889 131.954ZM123.444 131.954C123.439 132.479 123.297 132.994 123.033 133.449C122.769 133.903 122.392 134.282 121.939 134.548C121.485 134.814 120.97 134.959 120.444 134.968C119.918 134.977 119.398 134.851 118.935 134.6C118.473 134.35 118.083 133.985 117.803 133.54C117.524 133.094 117.364 132.585 117.34 132.06C117.316 131.535 117.428 131.013 117.665 130.544C117.903 130.076 118.258 129.676 118.696 129.384C119.286 128.993 119.994 128.818 120.699 128.89C121.404 128.961 122.062 129.275 122.561 129.777C122.845 130.064 123.069 130.404 123.221 130.777C123.372 131.151 123.448 131.551 123.444 131.954ZM142.999 131.954C142.994 132.404 142.89 132.847 142.694 133.252C142.497 133.656 142.213 134.013 141.862 134.295C141.511 134.577 141.102 134.778 140.664 134.884C140.226 134.989 139.77 134.996 139.329 134.905C138.739 134.783 138.198 134.491 137.774 134.063C137.35 133.636 137.062 133.093 136.946 132.503C136.83 131.912 136.892 131.301 137.125 130.746C137.357 130.191 137.749 129.717 138.251 129.384C138.629 129.134 139.057 128.97 139.506 128.906C139.954 128.841 140.411 128.876 140.845 129.01C141.278 129.143 141.676 129.371 142.01 129.677C142.344 129.982 142.606 130.358 142.776 130.778C142.928 131.15 143.003 131.55 142.999 131.954ZM6.1091 113.538C6.10902 113.939 6.02996 114.335 5.87641 114.705C5.72287 115.075 5.49785 115.411 5.21421 115.694C4.93057 115.977 4.59386 116.202 4.2233 116.355C3.85275 116.508 3.4556 116.587 3.05455 116.586C2.65349 116.586 2.25638 116.507 1.88588 116.354C1.51538 116.201 1.17875 115.976 0.895212 115.693C0.611674 115.41 0.38678 115.074 0.23337 114.704C0.0799594 114.334 0.00103767 113.938 0.00111046 113.537C0.00125746 112.729 0.323157 111.953 0.895996 111.382C1.46883 110.81 2.24569 110.489 3.05566 110.489C3.86563 110.49 4.64236 110.811 5.21499 111.383C5.78762 111.954 6.10924 112.73 6.1091 113.538ZM25.6646 113.538C25.6645 113.939 25.5853 114.335 25.4317 114.705C25.278 115.075 25.0529 115.411 24.7692 115.694C24.4854 115.977 24.1486 116.202 23.778 116.355C23.4073 116.508 23.0101 116.587 22.609 116.586C22.2078 116.586 21.8107 116.507 21.4401 116.354C21.0696 116.201 20.7329 115.976 20.4494 115.693C20.1659 115.409 19.941 115.073 19.7876 114.703C19.6342 114.333 19.5554 113.937 19.5555 113.536C19.5557 113.136 19.6348 112.74 19.7884 112.37C19.942 112 20.1671 111.664 20.4508 111.381C20.7345 111.098 21.0713 110.874 21.4418 110.72C21.8124 110.567 22.2096 110.489 22.6106 110.489C23.0117 110.489 23.4088 110.568 23.7793 110.721C24.1497 110.875 24.4863 111.099 24.7698 111.383C25.0533 111.666 25.2781 112.002 25.4315 112.372C25.5848 112.742 25.6637 113.138 25.6635 113.538H25.6646ZM45.219 113.538C45.2267 113.944 45.1534 114.346 45.0033 114.723C44.8533 115.099 44.6295 115.442 44.3452 115.731C44.0608 116.021 43.7216 116.25 43.3472 116.407C42.9729 116.564 42.571 116.645 42.165 116.645C41.7591 116.645 41.3572 116.564 40.9829 116.407C40.6087 116.25 40.2695 116.02 39.9852 115.731C39.701 115.441 39.4774 115.098 39.3275 114.722C39.1775 114.345 39.1044 113.943 39.1122 113.537C39.1123 112.729 39.4342 111.953 40.007 111.382C40.5799 110.81 41.3567 110.489 42.1667 110.489C42.9767 110.49 43.7534 110.811 44.326 111.383C44.8987 111.954 45.2192 112.73 45.219 113.538ZM64.779 113.538C64.7789 113.939 64.6999 114.335 64.5463 114.705C64.3928 115.075 64.1678 115.411 63.8841 115.694C63.6005 115.977 63.2638 116.202 62.8932 116.355C62.5227 116.508 62.1255 116.587 61.7245 116.586C61.3234 116.586 60.9263 116.507 60.5558 116.354C60.1853 116.201 59.8487 115.976 59.5651 115.693C59.2816 115.41 59.0567 115.074 58.9033 114.704C58.7499 114.334 58.6709 113.938 58.671 113.537C58.6712 112.729 58.9931 111.953 59.5659 111.382C60.1387 110.81 60.9156 110.489 61.7256 110.489C62.5355 110.49 63.3123 110.811 63.8849 111.383C64.4575 111.954 64.7792 112.73 64.779 113.538ZM84.3334 113.538C84.3411 113.944 84.2677 114.346 84.1177 114.723C83.9677 115.099 83.7439 115.442 83.4596 115.731C83.1752 116.021 82.8359 116.25 82.4616 116.407C82.0873 116.564 81.6854 116.645 81.2794 116.645C80.8735 116.645 80.4716 116.564 80.0973 116.407C79.723 116.25 79.3839 116.02 79.0996 115.731C78.8154 115.441 78.5917 115.098 78.4418 114.722C78.2919 114.345 78.2187 113.943 78.2265 113.537C78.2266 113.137 78.3057 112.741 78.4592 112.371C78.6128 112.001 78.8378 111.665 79.1214 111.382C79.4051 111.099 79.7418 110.874 80.1123 110.721C80.4829 110.568 80.88 110.489 81.2811 110.489C81.6822 110.489 82.0793 110.568 82.4498 110.722C82.8203 110.875 83.1569 111.1 83.4404 111.383C83.724 111.666 83.9489 112.002 84.1023 112.372C84.2557 112.742 84.3335 113.138 84.3334 113.538ZM103.889 113.538C103.897 113.944 103.823 114.346 103.673 114.723C103.523 115.099 103.299 115.442 103.015 115.731C102.731 116.021 102.391 116.25 102.017 116.407C101.643 116.564 101.241 116.645 100.835 116.645C100.429 116.645 100.027 116.564 99.6529 116.407C99.2786 116.25 98.9394 116.02 98.6551 115.731C98.3709 115.441 98.1473 115.098 97.9974 114.722C97.8475 114.345 97.7743 113.943 97.7821 113.537C97.7822 112.729 98.1041 111.953 98.677 111.382C99.2498 110.81 100.027 110.489 100.837 110.489C101.647 110.49 102.423 110.811 102.996 111.383C103.569 111.954 103.889 112.73 103.889 113.538ZM123.444 113.538C123.445 113.989 123.344 114.434 123.151 114.842C122.958 115.249 122.677 115.609 122.328 115.895C121.979 116.181 121.57 116.386 121.132 116.495C120.694 116.605 120.237 116.616 119.794 116.527C119.202 116.409 118.658 116.119 118.231 115.693C117.804 115.266 117.513 114.724 117.394 114.133C117.305 113.691 117.316 113.235 117.426 112.797C117.535 112.36 117.741 111.952 118.027 111.604C118.314 111.255 118.675 110.975 119.083 110.783C119.492 110.59 119.938 110.491 120.389 110.492C121.199 110.492 121.976 110.813 122.548 111.384C123.121 111.955 123.444 112.73 123.444 113.538ZM142.999 113.538C142.999 113.989 142.899 114.435 142.706 114.842C142.513 115.25 142.232 115.61 141.883 115.896C141.533 116.181 141.125 116.386 140.687 116.496C140.248 116.605 139.791 116.616 139.349 116.527C138.756 116.409 138.213 116.118 137.786 115.692C137.359 115.266 137.067 114.724 136.949 114.133C136.83 113.541 136.891 112.929 137.122 112.372C137.353 111.815 137.745 111.339 138.248 111.004C138.707 110.697 139.242 110.52 139.795 110.492C140.347 110.465 140.897 110.588 141.385 110.848C141.873 111.108 142.281 111.496 142.566 111.97C142.85 112.444 143 112.986 142.999 113.538ZM6.1091 95.1232C6.10937 95.574 6.00937 96.0193 5.81631 96.4268C5.62324 96.8344 5.34193 97.1941 4.99268 97.4799C4.64344 97.7658 4.23496 97.9706 3.79676 98.0798C3.35855 98.1889 2.90154 98.1995 2.45871 98.1109C2.01637 98.0226 1.59908 97.8377 1.23683 97.5694C0.874568 97.3011 0.576327 96.956 0.363522 96.559C0.150717 96.162 0.0286294 95.7228 0.00602638 95.2731C-0.0165767 94.8234 0.0608659 94.3743 0.232793 93.958C0.386135 93.5879 0.61105 93.2517 0.894673 92.9686C1.1783 92.6854 1.51506 92.4608 1.88571 92.3077C2.25636 92.1546 2.65361 92.0759 3.05475 92.0761C3.45589 92.0764 3.85304 92.1556 4.22349 92.3092C4.78128 92.5399 5.25809 92.9304 5.59369 93.4315C5.92929 93.9325 6.10864 94.5204 6.1091 95.1232ZM25.6646 95.1232C25.6647 95.5739 25.5646 96.0191 25.3714 96.4266C25.1783 96.834 24.897 97.1936 24.5478 97.4794C24.1986 97.7652 23.7902 97.9701 23.3521 98.0793C22.914 98.1885 22.457 98.1993 22.0142 98.1109C21.5717 98.0228 21.1541 97.838 20.7916 97.5696C20.4291 97.3013 20.1307 96.9562 19.9177 96.559C19.7048 96.1618 19.5827 95.7225 19.5601 95.2725C19.5375 94.8226 19.6151 94.3733 19.7872 93.9568C19.9406 93.5868 20.1655 93.2506 20.4491 92.9675C20.7327 92.6843 21.0695 92.4597 21.4401 92.3066C21.8108 92.1535 22.208 92.0748 22.6092 92.075C23.0103 92.0753 23.4075 92.1545 23.7779 92.3081C24.3359 92.5386 24.8129 92.9291 25.1488 93.4301C25.4846 93.9312 25.6641 94.5203 25.6646 95.1232ZM45.219 95.1232C45.2193 95.574 45.1193 96.0193 44.9263 96.4268C44.7332 96.8344 44.4519 97.1941 44.1026 97.4799C43.7534 97.7658 43.3449 97.9706 42.9067 98.0798C42.4685 98.1889 42.0115 98.1995 41.5687 98.1109C41.1262 98.0227 40.7088 97.8377 40.3464 97.5694C39.984 97.301 39.6857 96.9558 39.4729 96.5586C39.2601 96.1615 39.138 95.7222 39.1155 95.2723C39.093 94.8224 39.1706 94.3732 39.3427 93.9568C39.4961 93.5868 39.721 93.2506 40.0046 92.9675C40.2882 92.6843 40.625 92.4597 40.9957 92.3066C41.3663 92.1535 41.7636 92.0748 42.1647 92.075C42.5658 92.0753 42.963 92.1545 43.3334 92.3081C43.8912 92.5388 44.368 92.9293 44.7036 93.4304C45.0392 93.9314 45.2186 94.5204 45.219 95.1232ZM64.779 95.1232C64.7793 95.574 64.6793 96.0193 64.4862 96.4268C64.2931 96.8344 64.0118 97.1941 63.6626 97.4799C63.3133 97.7658 62.9049 97.9706 62.4667 98.0798C62.0285 98.1889 61.5714 98.1995 61.1286 98.1109C60.686 98.0229 60.2685 97.838 59.906 97.5697C59.5435 97.3013 59.2451 96.9561 59.0323 96.5589C58.8194 96.1617 58.6974 95.7223 58.675 95.2724C58.6526 94.8225 58.7304 94.3732 58.9027 93.9568C59.0946 93.4933 59.3982 93.0843 59.7864 92.7659C60.1747 92.4476 60.6357 92.2298 61.1285 92.132C61.6213 92.0341 62.1306 92.0592 62.6114 92.205C63.0921 92.3507 63.5294 92.6127 63.8844 92.9676C64.1681 93.2506 64.3931 93.5867 64.5466 93.9565C64.7001 94.3264 64.779 94.7228 64.779 95.1232ZM84.3334 95.1232C84.3337 95.574 84.2337 96.0193 84.0406 96.4268C83.8476 96.8344 83.5663 97.1941 83.217 97.4799C82.8678 97.7658 82.4593 97.9706 82.0211 98.0798C81.5829 98.1889 81.1259 98.1995 80.683 98.1109C80.2405 98.0229 79.8229 97.838 79.4604 97.5697C79.098 97.3013 78.7996 96.9561 78.5867 96.5589C78.3739 96.1617 78.2518 95.7223 78.2294 95.2724C78.207 94.8225 78.2848 94.3732 78.4571 93.9568C78.6105 93.5868 78.8354 93.2506 79.119 92.9675C79.4026 92.6843 79.7394 92.4597 80.11 92.3066C80.4807 92.1535 80.8779 92.0748 81.2791 92.075C81.6802 92.0753 82.0774 92.1545 82.4478 92.3081C83.0056 92.5388 83.4824 92.9293 83.818 93.4304C84.1536 93.9314 84.333 94.5204 84.3334 95.1232ZM103.889 95.1232C103.889 95.574 103.789 96.0193 103.596 96.4268C103.403 96.8344 103.122 97.1941 102.773 97.4799C102.423 97.7658 102.015 97.9706 101.577 98.0798C101.138 98.1889 100.681 98.1995 100.239 98.1109C99.7961 98.0227 99.3787 97.8377 99.0163 97.5694C98.6539 97.301 98.3556 96.9558 98.1428 96.5586C97.93 96.1615 97.8079 95.7222 97.7854 95.2723C97.7629 94.8224 97.8405 94.3732 98.0126 93.9568C98.166 93.5868 98.3909 93.2506 98.6745 92.9675C98.9582 92.6843 99.2949 92.4597 99.6656 92.3066C100.036 92.1535 100.433 92.0748 100.835 92.075C101.236 92.0753 101.633 92.1545 102.003 92.3081C102.561 92.5388 103.038 92.9293 103.374 93.4304C103.709 93.9314 103.888 94.5204 103.889 95.1232ZM123.444 95.1232C123.445 95.726 123.266 96.3154 122.93 96.8166C122.594 97.3177 122.117 97.7081 121.559 97.9382C121.001 98.168 120.387 98.2278 119.796 98.1099C119.204 97.9921 118.66 97.702 118.233 97.2762C117.806 96.8504 117.515 96.3079 117.397 95.7172C117.278 95.1265 117.337 94.5139 117.567 93.9568C117.839 93.3063 118.327 92.7697 118.95 92.4381C119.573 92.1065 120.292 92.0004 120.984 92.1378C121.677 92.2752 122.3 92.6476 122.748 93.1918C123.197 93.736 123.443 94.4185 123.444 95.1232ZM142.999 95.1232C142.999 95.7261 142.82 96.3155 142.485 96.8167C142.149 97.3179 141.672 97.7083 141.113 97.9382C140.414 98.2252 139.632 98.2427 138.92 97.9873C138.208 97.7319 137.616 97.2219 137.26 96.5559C136.903 95.89 136.807 95.1156 136.989 94.3828C137.172 93.6499 137.62 93.0107 138.248 92.5891C138.708 92.2831 139.242 92.1074 139.794 92.0806C140.346 92.0538 140.895 92.177 141.383 92.437C141.87 92.697 142.278 93.0841 142.563 93.5572C142.847 94.0302 142.998 94.5714 142.999 95.1232ZM6.1091 76.7078C6.10937 77.1587 6.00937 77.6039 5.81631 78.0115C5.62324 78.4191 5.34193 78.7787 4.99268 79.0646C4.64344 79.3504 4.23496 79.5553 3.79676 79.6644C3.35855 79.7735 2.90154 79.7842 2.45871 79.6955C2.01637 79.6073 1.59908 79.4224 1.23683 79.1541C0.874568 78.8858 0.576327 78.5407 0.363522 78.1437C0.150717 77.7467 0.0286294 77.3075 0.00602638 76.8578C-0.0165767 76.4081 0.0608659 75.9589 0.232793 75.5426C0.463869 74.9854 0.855421 74.5092 1.35785 74.1743C1.86027 73.8395 2.45097 73.661 3.0551 73.6615C3.86479 73.6618 4.64125 73.9829 5.21389 74.5543C5.78652 75.1257 6.10851 75.8996 6.1091 76.7078ZM25.6646 76.7078C25.6647 77.1586 25.5646 77.6038 25.3714 78.0112C25.1783 78.4187 24.897 78.7783 24.5478 79.0641C24.1986 79.3499 23.7902 79.5548 23.3521 79.664C22.914 79.7732 22.457 79.784 22.0142 79.6955C21.5717 79.6075 21.1541 79.4227 20.7916 79.1543C20.4291 78.886 20.1307 78.5408 19.9177 78.1436C19.7048 77.7465 19.5827 77.3071 19.5601 76.8572C19.5375 76.4073 19.6151 75.958 19.7872 75.5415C20.0183 74.9843 20.4098 74.5081 20.9123 74.1732C21.4147 73.8383 22.0054 73.6599 22.6095 73.6604C23.4193 73.6607 24.1959 73.9818 24.7687 74.5531C25.3415 75.1245 25.6637 75.8995 25.6646 76.7078ZM45.219 76.7078C45.2193 77.1587 45.1193 77.6039 44.9263 78.0115C44.7332 78.4191 44.4519 78.7787 44.1026 79.0646C43.7534 79.3504 43.3449 79.5553 42.9067 79.6644C42.4685 79.7735 42.0115 79.7842 41.5687 79.6955C41.1262 79.6074 40.7088 79.4224 40.3464 79.154C39.984 78.8856 39.6857 78.5405 39.4729 78.1433C39.2601 77.7461 39.138 77.3068 39.1155 76.857C39.093 76.4071 39.1706 75.9579 39.3427 75.5415C39.5738 74.9843 39.9654 74.5081 40.4678 74.1732C40.9702 73.8383 41.5609 73.6599 42.165 73.6604C42.9747 73.6607 43.7512 73.9818 44.3238 74.5532C44.8965 75.1246 45.2185 75.8996 45.219 76.7078ZM64.779 76.7078C64.7793 77.1587 64.6793 77.6039 64.4862 78.0115C64.2931 78.4191 64.0118 78.7787 63.6626 79.0646C63.3133 79.3504 62.9049 79.5553 62.4667 79.6644C62.0285 79.7735 61.5714 79.7842 61.1286 79.6955C60.686 79.6075 60.2685 79.4227 59.906 79.1544C59.5435 78.886 59.2451 78.5408 59.0323 78.1436C58.8194 77.7464 58.6974 77.307 58.675 76.8571C58.6526 76.4072 58.7304 75.9579 58.9027 75.5415C59.0947 75.0781 59.3984 74.6691 59.7867 74.3509C60.175 74.0327 60.636 73.815 61.1288 73.7173C61.6216 73.6196 62.1309 73.6447 62.6116 73.7906C63.0923 73.9364 63.5295 74.1984 63.8844 74.5534C64.4575 75.1244 64.779 75.9 64.779 76.7078ZM84.3334 76.7078C84.3337 77.1587 84.2337 77.6039 84.0406 78.0115C83.8476 78.4191 83.5663 78.7787 83.217 79.0646C82.8678 79.3504 82.4593 79.5553 82.0211 79.6644C81.5829 79.7735 81.1259 79.7842 80.683 79.6955C80.2405 79.6075 79.8229 79.4227 79.4604 79.1544C79.098 78.886 78.7996 78.5408 78.5867 78.1436C78.3739 77.7464 78.2518 77.307 78.2294 76.8571C78.207 76.4072 78.2848 75.9579 78.4571 75.5415C78.6882 74.9843 79.0798 74.5081 79.5822 74.1732C80.0846 73.8383 80.6753 73.6599 81.2794 73.6604C82.089 73.661 82.8653 73.9822 83.4379 74.5535C84.0105 75.1249 84.3325 75.8997 84.3334 76.7078ZM103.889 76.7078C103.889 77.1587 103.789 77.6039 103.596 78.0115C103.403 78.4191 103.122 78.7787 102.773 79.0646C102.423 79.3504 102.015 79.5553 101.577 79.6644C101.138 79.7735 100.681 79.7842 100.239 79.6955C99.7961 79.6074 99.3787 79.4224 99.0163 79.154C98.6539 78.8856 98.3556 78.5405 98.1428 78.1433C97.93 77.7461 97.8079 77.3068 97.7854 76.857C97.7629 76.4071 97.8405 75.9579 98.0126 75.5415C98.166 75.1715 98.3909 74.8353 98.6745 74.5521C98.9582 74.269 99.2949 74.0444 99.6656 73.8913C100.036 73.7381 100.433 73.6594 100.835 73.6597C101.236 73.66 101.633 73.7391 102.003 73.8928C102.561 74.1235 103.038 74.514 103.374 75.015C103.709 75.5161 103.888 76.1051 103.889 76.7078ZM123.444 76.7078C123.445 77.3107 123.266 77.9001 122.93 78.4013C122.594 78.9024 122.117 79.2928 121.559 79.5229C121.001 79.7527 120.387 79.8124 119.796 79.6946C119.204 79.5768 118.66 79.2867 118.233 78.8609C117.806 78.4351 117.515 77.8926 117.397 77.3019C117.278 76.7112 117.337 76.0986 117.567 75.5415C117.839 74.891 118.327 74.3544 118.95 74.0228C119.573 73.6912 120.292 73.5851 120.984 73.7225C121.677 73.8598 122.3 74.2323 122.748 74.7765C123.197 75.3207 123.443 76.0031 123.444 76.7078ZM142.999 76.7078C142.999 77.3107 142.82 77.9002 142.485 78.4014C142.149 78.9026 141.672 79.2929 141.113 79.5229C140.414 79.8099 139.632 79.8274 138.92 79.572C138.208 79.3166 137.616 78.8065 137.26 78.1406C136.903 77.4747 136.807 76.7003 136.989 75.9674C137.172 75.2346 137.62 74.5954 138.248 74.1738C138.708 73.8678 139.242 73.6921 139.794 73.6653C140.346 73.6385 140.895 73.7616 141.383 74.0217C141.87 74.2817 142.278 74.6688 142.563 75.1418C142.847 75.6149 142.998 76.1561 142.999 76.7078ZM6.1091 58.2925C6.10937 58.7433 6.00937 59.1886 5.81631 59.5962C5.62324 60.0037 5.34193 60.3634 4.99268 60.6493C4.64344 60.9351 4.23496 61.14 3.79676 61.2491C3.35855 61.3582 2.90154 61.3688 2.45871 61.2802C2.01637 61.192 1.59908 61.0071 1.23683 60.7388C0.874568 60.4704 0.576327 60.1254 0.363522 59.7284C0.150717 59.3313 0.0286294 58.8922 0.00602638 58.4425C-0.0165767 57.9927 0.0608659 57.5436 0.232793 57.1273C0.424824 56.6639 0.728466 56.2549 1.11678 55.9367C1.5051 55.6185 1.9661 55.4008 2.45887 55.3031C2.95165 55.2053 3.46097 55.2305 3.94167 55.3763C4.42236 55.5222 4.85957 55.7842 5.21451 56.1391C5.78762 56.7101 6.1091 57.4847 6.1091 58.2925ZM25.6646 58.2936C25.6647 58.7444 25.5646 59.1895 25.3714 59.597C25.1783 60.0045 24.897 60.3641 24.5478 60.6499C24.1986 60.9357 23.7902 61.1406 23.3521 61.2498C22.914 61.359 22.457 61.3697 22.0142 61.2813C21.5717 61.1933 21.1541 61.0084 20.7916 60.7401C20.4291 60.4718 20.1307 60.1266 19.9177 59.7294C19.7048 59.3322 19.5827 58.8929 19.5601 58.443C19.5375 57.9931 19.6151 57.5437 19.7872 57.1273C20.0183 56.5701 20.4098 56.0939 20.9123 55.759C21.4147 55.4241 22.0054 55.2456 22.6095 55.2462C23.4191 55.2464 24.1955 55.5674 24.7683 56.1385C25.3411 56.7097 25.6635 57.4855 25.6646 58.2936ZM45.219 58.2936C45.2193 58.7444 45.1193 59.1897 44.9263 59.5973C44.7332 60.0048 44.4519 60.3645 44.1026 60.6504C43.7534 60.9362 43.3449 61.1411 42.9067 61.2502C42.4685 61.3593 42.0115 61.3699 41.5687 61.2813C41.1262 61.1931 40.7088 61.0082 40.3464 60.7398C39.984 60.4714 39.6857 60.1262 39.4729 59.7291C39.2601 59.3319 39.138 58.8926 39.1155 58.4428C39.093 57.9929 39.1706 57.5437 39.3427 57.1273C39.5738 56.5701 39.9654 56.0939 40.4678 55.759C40.9702 55.4241 41.5609 55.2456 42.165 55.2462C42.9745 55.2464 43.7508 55.5674 44.3234 56.1386C44.896 56.7098 45.2182 57.4856 45.219 58.2936ZM64.779 58.2936C64.7793 58.7444 64.6793 59.1897 64.4862 59.5973C64.2931 60.0048 64.0118 60.3645 63.6626 60.6504C63.3133 60.9362 62.9049 61.1411 62.4667 61.2502C62.0285 61.3593 61.5714 61.3699 61.1286 61.2813C60.686 61.1933 60.2685 61.0085 59.906 60.7401C59.5435 60.4718 59.2451 60.1266 59.0323 59.7294C58.8194 59.3322 58.6974 58.8928 58.675 58.4429C58.6526 57.9929 58.7304 57.5436 58.9027 57.1273C59.0946 56.6638 59.3982 56.2547 59.7864 55.9364C60.1747 55.618 60.6357 55.4003 61.1285 55.3024C61.6213 55.2046 62.1306 55.2296 62.6114 55.3754C63.0921 55.5212 63.5294 55.7831 63.8844 56.138C64.4575 56.7101 64.779 57.4858 64.779 58.2936ZM84.3334 58.2936C84.3337 58.7444 84.2337 59.1897 84.0406 59.5973C83.8476 60.0048 83.5663 60.3645 83.217 60.6504C82.8678 60.9362 82.4593 61.1411 82.0211 61.2502C81.5829 61.3593 81.1259 61.3699 80.683 61.2813C80.2405 61.1933 79.8229 61.0085 79.4604 60.7401C79.098 60.4718 78.7996 60.1266 78.5867 59.7294C78.3739 59.3322 78.2518 58.8928 78.2294 58.4429C78.207 57.9929 78.2848 57.5436 78.4571 57.1273C78.6882 56.5701 79.0798 56.0939 79.5822 55.759C80.0846 55.4241 80.6753 55.2456 81.2794 55.2462C82.0888 55.2467 82.865 55.5678 83.4375 56.1389C84.01 56.71 84.3323 57.4856 84.3334 58.2936ZM103.889 58.2936C103.889 58.7444 103.789 59.1897 103.596 59.5973C103.403 60.0048 103.122 60.3645 102.773 60.6504C102.423 60.9362 102.015 61.1411 101.577 61.2502C101.138 61.3593 100.681 61.3699 100.239 61.2813C99.7961 61.1931 99.3787 61.0082 99.0163 60.7398C98.6539 60.4714 98.3556 60.1262 98.1428 59.7291C97.93 59.3319 97.8079 58.8926 97.7854 58.4428C97.7629 57.9929 97.8405 57.5437 98.0126 57.1273C98.166 56.7573 98.3909 56.4211 98.6745 56.1379C98.9582 55.8547 99.2949 55.6302 99.6656 55.477C100.036 55.3239 100.433 55.2452 100.835 55.2455C101.236 55.2457 101.633 55.3249 102.003 55.4785C102.561 55.7092 103.038 56.0995 103.373 56.6003C103.709 57.1012 103.888 57.6911 103.889 58.2936ZM123.444 58.2925C123.445 58.8954 123.266 59.4848 122.93 59.9859C122.594 60.4871 122.117 60.8775 121.559 61.1076C121.001 61.3374 120.387 61.3971 119.796 61.2793C119.204 61.1615 118.66 60.8714 118.233 60.4455C117.806 60.0197 117.515 59.4773 117.397 58.8865C117.278 58.2958 117.337 57.6833 117.567 57.1262C117.76 56.6633 118.064 56.255 118.452 55.9373C118.841 55.6196 119.302 55.4023 119.794 55.3046C120.287 55.207 120.796 55.2319 121.277 55.3773C121.757 55.5226 122.194 55.7839 122.55 56.138C123.122 56.709 123.444 57.4847 123.444 58.2925ZM142.999 58.2936C142.999 58.8965 142.82 59.486 142.485 59.9872C142.149 60.4884 141.672 60.8787 141.113 61.1087C140.555 61.3387 139.942 61.3986 139.35 61.2809C138.758 61.1631 138.214 60.873 137.787 60.4471C137.36 60.0211 137.069 59.4785 136.951 58.8877C136.833 58.2969 136.892 57.6843 137.123 57.1273C137.315 56.6644 137.619 56.2559 138.007 55.9381C138.396 55.6203 138.856 55.4028 139.349 55.305C139.841 55.2072 140.35 55.2321 140.831 55.3774C141.312 55.5227 141.749 55.7839 142.104 56.138C142.677 56.7101 142.999 57.4858 142.999 58.2936ZM6.1091 39.7455C6.10937 40.1963 6.00937 40.6416 5.81631 41.0492C5.62324 41.4567 5.34193 41.8164 4.99268 42.1023C4.64344 42.3881 4.23496 42.593 3.79676 42.7021C3.35855 42.8112 2.90154 42.8218 2.45871 42.7332C2.01623 42.645 1.59881 42.4601 1.23644 42.1917C0.874074 41.9233 0.575762 41.5781 0.36294 41.181C0.150118 40.7838 0.0280707 40.3445 0.00556779 39.8946C-0.0169351 39.4448 0.0606652 38.9955 0.232793 38.5792C0.424824 38.1157 0.728466 37.7068 1.11678 37.3886C1.5051 37.0703 1.9661 36.8527 2.45887 36.755C2.95165 36.6572 3.46097 36.6824 3.94167 36.8282C4.42236 36.9741 4.85957 37.2361 5.21451 37.591C5.49822 37.8738 5.72327 38.2096 5.87678 38.5793C6.03028 38.949 6.10923 39.3453 6.1091 39.7455ZM25.6646 39.7455C25.6647 40.1963 25.5646 40.6414 25.3714 41.0489C25.1783 41.4564 24.897 41.816 24.5478 42.1018C24.1986 42.3876 23.7902 42.5925 23.3521 42.7017C22.914 42.8108 22.457 42.8216 22.0142 42.7332C21.5717 42.6452 21.1541 42.4603 20.7916 42.192C20.4291 41.9237 20.1307 41.5785 19.9177 41.1813C19.7048 40.7841 19.5827 40.3448 19.5601 39.8949C19.5375 39.4449 19.6151 38.9956 19.7872 38.5792C20.0184 38.0221 20.41 37.5459 20.9124 37.2111C21.4148 36.8762 22.0054 36.6977 22.6095 36.698C23.4193 36.6983 24.1959 37.0194 24.7687 37.5908C25.3415 38.1622 25.6637 38.9371 25.6646 39.7455ZM45.219 39.7455C45.2193 40.1963 45.1193 40.6416 44.9263 41.0492C44.7332 41.4567 44.4519 41.8164 44.1026 42.1023C43.7534 42.3881 43.3449 42.593 42.9067 42.7021C42.4685 42.8112 42.0115 42.8218 41.5687 42.7332C41.1262 42.645 40.7088 42.4601 40.3464 42.1917C39.984 41.9233 39.6857 41.5781 39.4729 41.181C39.2601 40.7838 39.138 40.3445 39.1155 39.8946C39.093 39.4448 39.1706 38.9955 39.3427 38.5792C39.5348 38.1157 39.8384 37.7068 40.2267 37.3886C40.6151 37.0703 41.076 36.8527 41.5688 36.755C42.0616 36.6572 42.5709 36.6824 43.0516 36.8282C43.5323 36.9741 43.9695 37.2361 44.3245 37.591C44.6082 37.8738 44.8332 38.2096 44.9867 38.5793C45.1402 38.949 45.2192 39.3453 45.219 39.7455ZM64.779 39.7455C64.7793 40.1963 64.6793 40.6416 64.4862 41.0492C64.2931 41.4567 64.0118 41.8164 63.6626 42.1023C63.3133 42.3881 62.9049 42.593 62.4667 42.7021C62.0285 42.8112 61.5714 42.8218 61.1286 42.7332C60.686 42.6452 60.2685 42.4604 59.906 42.192C59.5435 41.9237 59.2451 41.5785 59.0323 41.1813C58.8194 40.784 58.6974 40.3447 58.675 39.8947C58.6526 39.4448 58.7304 38.9955 58.9027 38.5792C59.1732 37.9278 59.6616 37.3902 60.2846 37.0578C60.9076 36.7255 61.6268 36.619 62.3196 36.7566C63.0124 36.8941 63.636 37.2671 64.0843 37.8121C64.5325 38.3571 64.7787 39.0404 64.779 39.7455ZM84.3334 39.7455C84.3337 40.1963 84.2337 40.6416 84.0406 41.0492C83.8476 41.4567 83.5663 41.8164 83.217 42.1023C82.8678 42.3881 82.4593 42.593 82.0211 42.7021C81.5829 42.8112 81.1259 42.8218 80.683 42.7332C80.2405 42.6452 79.8229 42.4604 79.4604 42.192C79.098 41.9237 78.7996 41.5785 78.5867 41.1813C78.3739 40.784 78.2518 40.3447 78.2294 39.8947C78.207 39.4448 78.2848 38.9955 78.4571 38.5792C78.6492 38.1157 78.9528 37.7068 79.3411 37.3886C79.7294 37.0703 80.1904 36.8527 80.6832 36.755C81.176 36.6572 81.6853 36.6824 82.166 36.8282C82.6467 36.9741 83.0839 37.2361 83.4388 37.591C83.7225 37.8738 83.9476 38.2096 84.1011 38.5793C84.2546 38.949 84.3336 39.3453 84.3334 39.7455ZM103.889 39.7455C103.889 40.1963 103.789 40.6416 103.596 41.0492C103.403 41.4567 103.122 41.8164 102.773 42.1023C102.423 42.3881 102.015 42.593 101.577 42.7021C101.138 42.8112 100.681 42.8218 100.239 42.7332C99.7961 42.645 99.3787 42.4601 99.0163 42.1917C98.6539 41.9233 98.3556 41.5781 98.1428 41.181C97.93 40.7838 97.8079 40.3445 97.7854 39.8946C97.7629 39.4448 97.8405 38.9955 98.0126 38.5792C98.1661 38.2093 98.3911 37.8732 98.6747 37.5901C98.9584 37.307 99.2951 37.0825 99.6657 36.9293C100.036 36.7762 100.434 36.6975 100.835 36.6977C101.236 36.6979 101.633 36.777 102.003 36.9304C102.561 37.1611 103.038 37.5517 103.374 38.0527C103.709 38.5537 103.888 39.1428 103.889 39.7455ZM123.444 39.7455C123.445 40.3484 123.266 40.9378 122.93 41.4389C122.594 41.9401 122.117 42.3305 121.559 42.5606C121.142 42.7326 120.691 42.8102 120.241 42.7879C119.79 42.7657 119.349 42.644 118.951 42.4317C118.553 42.2193 118.207 41.9216 117.938 41.56C117.669 41.1983 117.483 40.7815 117.394 40.3397C117.305 39.8977 117.316 39.4415 117.426 39.0042C117.535 38.5668 117.741 38.1592 118.027 37.8109C118.314 37.4625 118.675 37.182 119.083 36.9898C119.492 36.7975 119.938 36.6982 120.389 36.6991C121.199 36.6997 121.975 37.0208 122.548 37.5918C123.121 38.1629 123.443 38.9374 123.444 39.7455ZM142.999 39.7455C142.999 40.3484 142.82 40.9379 142.485 41.439C142.149 41.9402 141.672 42.3306 141.113 42.5606C140.555 42.7906 139.942 42.8505 139.35 42.7328C138.758 42.615 138.214 42.3249 137.787 41.8989C137.36 41.473 137.069 40.9304 136.951 40.3396C136.833 39.7488 136.892 39.1362 137.123 38.5792C137.315 38.1165 137.62 37.7084 138.008 37.3909C138.396 37.0733 138.857 36.8561 139.349 36.7584C139.842 36.6608 140.351 36.6856 140.831 36.8308C141.312 36.9761 141.749 37.2371 142.104 37.591C142.388 37.8738 142.613 38.2096 142.767 38.5793C142.92 38.949 142.999 39.3453 142.999 39.7455ZM6.1091 21.4618C6.10954 21.9128 6.00966 22.3582 5.81666 22.7659C5.62367 23.1736 5.34238 23.5334 4.99311 23.8194C4.64384 24.1053 4.23531 24.3103 3.79702 24.4195C3.35874 24.5287 2.90163 24.5393 2.45871 24.4507C2.01619 24.3623 1.59876 24.1773 1.23639 23.9088C0.874028 23.6403 0.575728 23.295 0.362919 22.8977C0.15011 22.5005 0.0280733 22.0611 0.00557439 21.6112C-0.0169245 21.1613 0.0606727 20.712 0.232793 20.2955C0.424824 19.8321 0.728466 19.4231 1.11678 19.1049C1.5051 18.7867 1.9661 18.5691 2.45887 18.4713C2.95165 18.3736 3.46097 18.3987 3.94167 18.5446C4.42236 18.6904 4.85957 18.9524 5.21451 19.3074C5.78762 19.8795 6.1091 20.6541 6.1091 21.4618ZM25.6646 21.4618C25.6649 21.9127 25.5649 22.358 25.3718 22.7656C25.1787 23.1732 24.8975 23.5329 24.5482 23.8189C24.199 24.1048 23.7906 24.3098 23.3524 24.419C22.9142 24.5283 22.4571 24.5391 22.0142 24.4507C21.5716 24.3625 21.1541 24.1775 20.7916 23.9091C20.4291 23.6406 20.1306 23.2954 19.9177 22.8981C19.7048 22.5008 19.5827 22.0614 19.5601 21.6114C19.5375 21.1614 19.6151 20.712 19.7872 20.2955C20.0183 19.7383 20.4098 19.2621 20.9123 18.9272C21.4147 18.5924 22.0054 18.4139 22.6095 18.4144C23.4193 18.4147 24.1959 18.7358 24.7687 19.3072C25.3415 19.8785 25.6637 20.6535 25.6646 21.4618ZM45.219 21.4618C45.2193 22.0646 45.0403 22.6538 44.7048 23.1549C44.3694 23.656 43.8925 24.0465 43.3345 24.2769C42.9173 24.4491 42.4671 24.527 42.0162 24.5049C41.5652 24.4827 41.1248 24.3612 40.7265 24.149C40.3283 23.9368 39.982 23.6391 39.7127 23.2774C39.4433 22.9158 39.2575 22.499 39.1687 22.0572C39.0802 21.615 39.0912 21.1588 39.2009 20.7214C39.3106 20.284 39.5162 19.8764 39.8028 19.5279C40.0895 19.1795 40.4501 18.899 40.8586 18.7066C41.2672 18.5142 41.7134 18.4148 42.165 18.4155C42.9745 18.4158 43.7508 18.7368 44.3234 19.3079C44.896 19.8791 45.2182 20.6538 45.219 21.4618ZM64.779 21.4618C64.7791 22.0647 64.6 22.654 64.2643 23.1552C63.9287 23.6563 63.4515 24.0467 62.8934 24.2769C62.4762 24.4489 62.0261 24.5266 61.5753 24.5044C61.1245 24.4822 60.6843 24.3606 60.2861 24.1484C59.888 23.9362 59.5418 23.6386 59.2726 23.2771C59.0033 22.9155 58.8175 22.4989 58.7287 22.0572C58.6404 21.6151 58.6515 21.1591 58.7612 20.7218C58.8709 20.2846 59.0764 19.8771 59.3629 19.5288C59.6495 19.1804 60.0099 18.8999 60.4181 18.7074C60.8264 18.5148 61.2724 18.4152 61.7239 18.4155C62.5336 18.4155 63.3102 18.7363 63.883 19.3076C64.4559 19.8788 64.7781 20.6536 64.779 21.4618ZM84.3334 21.4618C84.3336 22.0646 84.1547 22.6538 83.8192 23.1549C83.4838 23.656 83.0069 24.0465 82.4489 24.2769C82.0317 24.4491 81.5815 24.527 81.1306 24.5049C80.6796 24.4827 80.2392 24.3612 79.8409 24.149C79.4426 23.9368 79.0964 23.6391 78.827 23.2774C78.5577 22.9158 78.3719 22.499 78.2831 22.0572C78.165 21.4659 78.2254 20.853 78.4567 20.2961C78.688 19.7392 79.0797 19.2633 79.5823 18.9289C80.0422 18.6229 80.5767 18.4472 81.1288 18.4204C81.6809 18.3936 82.2299 18.5168 82.7175 18.7768C83.205 19.0368 83.6127 19.4239 83.8973 19.897C84.1819 20.37 84.3326 20.9101 84.3334 21.4618ZM103.889 21.4618C103.889 22.0647 103.71 22.654 103.374 23.1552C103.039 23.6563 102.561 24.0467 102.003 24.2769C101.586 24.4489 101.136 24.5266 100.685 24.5044C100.234 24.4822 99.7942 24.3606 99.3961 24.1484C98.9979 23.9362 98.6518 23.6386 98.3825 23.2771C98.1132 22.9155 97.9275 22.4989 97.8386 22.0572C97.7501 21.615 97.7611 21.1588 97.8708 20.7214C97.9805 20.284 98.1861 19.8764 98.4727 19.5279C98.7594 19.1795 99.12 18.899 99.5286 18.7066C99.9371 18.5142 100.383 18.4148 100.835 18.4155C101.644 18.4161 102.42 18.7372 102.993 19.3083C103.566 19.8794 103.888 20.6539 103.889 21.4618ZM123.444 21.4618C123.445 22.0647 123.266 22.6541 122.93 23.1553C122.594 23.6564 122.117 24.0468 121.559 24.2769C121.142 24.4489 120.692 24.5266 120.241 24.5044C119.79 24.4822 119.35 24.3606 118.952 24.1484C118.553 23.9362 118.207 23.6386 117.938 23.2771C117.669 22.9155 117.483 22.4989 117.394 22.0572C117.305 21.6151 117.316 21.1588 117.425 20.7213C117.535 20.2838 117.74 19.8761 118.027 19.5276C118.314 19.179 118.674 18.8985 119.083 18.7062C119.491 18.5138 119.938 18.4146 120.389 18.4155C121.199 18.4161 121.975 18.7371 122.548 19.3082C123.121 19.8793 123.443 20.6538 123.444 21.4618ZM142.999 21.4618C142.999 22.0648 142.82 22.6542 142.485 23.1554C142.149 23.6566 141.672 24.0469 141.113 24.2769C140.696 24.4492 140.246 24.527 139.795 24.5049C139.344 24.4827 138.904 24.3612 138.506 24.149C138.108 23.9367 137.761 23.6391 137.492 23.2774C137.223 22.9157 137.037 22.499 136.949 22.0572C136.83 21.4659 136.891 20.853 137.122 20.2961C137.353 19.7392 137.745 19.2633 138.248 18.9289C138.708 18.6229 139.242 18.4472 139.794 18.4204C140.346 18.3936 140.895 18.5168 141.383 18.7768C141.87 19.0368 142.278 19.4239 142.563 19.897C142.847 20.37 142.998 20.9101 142.999 21.4618ZM6.1091 3.04763C6.10937 3.49846 6.00937 3.94373 5.81631 4.35129C5.62324 4.75886 5.34193 5.11854 4.99268 5.40439C4.64344 5.69024 4.23496 5.89511 3.79676 6.00422C3.35855 6.11333 2.90154 6.12396 2.45871 6.03533C2.01623 5.94715 1.59881 5.76221 1.23644 5.49383C0.874074 5.22544 0.575762 4.88026 0.36294 4.48309C0.150118 4.08593 0.0280707 3.64663 0.00556779 3.19677C-0.0169351 2.74692 0.0606652 2.29767 0.232793 1.88132C0.424824 1.41788 0.728466 1.00891 1.11678 0.690695C1.5051 0.372476 1.9661 0.154842 2.45887 0.0570975C2.95165 -0.0406476 3.46097 -0.0154822 3.94167 0.130361C4.42236 0.276205 4.85957 0.538218 5.21451 0.89316C5.49822 1.17591 5.72327 1.51175 5.87678 1.88145C6.03028 2.25114 6.10923 2.64743 6.1091 3.04763ZM25.6646 3.04763C25.6647 3.49839 25.5646 3.94356 25.3714 4.35103C25.1783 4.75849 24.897 5.11809 24.5478 5.4039C24.1986 5.6897 23.7902 5.89459 23.3521 6.00378C22.914 6.11297 22.457 6.12375 22.0142 6.03533C21.5717 5.94728 21.1541 5.76245 20.7916 5.49412C20.4291 5.22579 20.1307 4.88063 19.9177 4.48345C19.7048 4.08626 19.5827 3.64692 19.5601 3.197C19.5375 2.74707 19.6151 2.29775 19.7872 1.88132C19.9406 1.5113 20.1655 1.17509 20.4491 0.891925C20.7327 0.608757 21.0695 0.384182 21.4401 0.231049C21.8108 0.0779146 22.208 -0.000774451 22.6092 -0.000517636C23.0103 -0.000260821 23.4075 0.0789368 23.7779 0.232545C24.3359 0.463093 24.8129 0.853551 25.1488 1.35459C25.4846 1.85564 25.6641 2.44479 25.6646 3.04763ZM45.219 3.04763C45.2193 3.49846 45.1193 3.94373 44.9263 4.35129C44.7332 4.75886 44.4519 5.11854 44.1026 5.40439C43.7534 5.69024 43.3449 5.89511 42.9067 6.00422C42.4685 6.11333 42.0115 6.12396 41.5687 6.03533C41.1262 5.94715 40.7088 5.76221 40.3464 5.49383C39.984 5.22544 39.6857 4.88026 39.4729 4.48309C39.2601 4.08593 39.138 3.64663 39.1155 3.19677C39.093 2.74692 39.1706 2.29767 39.3427 1.88132C39.5348 1.41788 39.8384 1.00891 40.2267 0.690695C40.6151 0.372476 41.076 0.154842 41.5688 0.0570975C42.0616 -0.0406476 42.5709 -0.0154822 43.0516 0.130361C43.5323 0.276205 43.9695 0.538218 44.3245 0.89316C44.6082 1.17591 44.8332 1.51175 44.9867 1.88145C45.1402 2.25114 45.2192 2.64743 45.219 3.04763ZM64.779 3.04763C64.7793 3.49846 64.6793 3.94373 64.4862 4.35129C64.2931 4.75886 64.0118 5.11854 63.6626 5.40439C63.3133 5.69024 62.9049 5.89511 62.4667 6.00422C62.0285 6.11333 61.5714 6.12396 61.1286 6.03533C60.6861 5.94715 60.2687 5.76221 59.9063 5.49383C59.544 5.22544 59.2457 4.88026 59.0328 4.48309C58.82 4.08593 58.698 3.64663 58.6755 3.19677C58.653 2.74692 58.7306 2.29767 58.9027 1.88132C59.1732 1.22993 59.6616 0.692287 60.2846 0.35996C60.9076 0.0276324 61.6268 -0.0788293 62.3196 0.0587065C63.0124 0.196242 63.636 0.56927 64.0843 1.11426C64.5325 1.65925 64.7787 2.34249 64.779 3.04763ZM84.3334 3.04763C84.3337 3.49846 84.2337 3.94373 84.0406 4.35129C83.8476 4.75886 83.5663 5.11854 83.217 5.40439C82.8678 5.69024 82.4593 5.89511 82.0211 6.00422C81.5829 6.11333 81.1259 6.12396 80.683 6.03533C80.2406 5.94715 79.8231 5.76221 79.4608 5.49383C79.0984 5.22544 78.8001 4.88026 78.5873 4.48309C78.3744 4.08593 78.2524 3.64663 78.2299 3.19677C78.2074 2.74692 78.285 2.29767 78.4571 1.88132C78.6883 1.3242 79.0799 0.848076 79.5823 0.513213C80.0847 0.17835 80.6753 -0.000198131 81.2794 0.000168145C82.089 0.000753926 82.8653 0.321977 83.4379 0.893328C84.0105 1.46468 84.3325 2.23947 84.3334 3.04763ZM103.889 3.04763C103.889 3.49846 103.789 3.94373 103.596 4.35129C103.403 4.75886 103.122 5.11854 102.773 5.40439C102.423 5.69024 102.015 5.89511 101.577 6.00422C101.138 6.11333 100.681 6.12396 100.239 6.03533C99.7961 5.94715 99.3787 5.76221 99.0163 5.49383C98.6539 5.22544 98.3556 4.88026 98.1428 4.48309C97.93 4.08593 97.8079 3.64663 97.7854 3.19677C97.7629 2.74692 97.8405 2.29767 98.0126 1.88132C98.2437 1.32411 98.6353 0.847908 99.1377 0.513026C99.6401 0.178145 100.231 -0.000344622 100.835 0.000168145C101.645 0.000461201 102.421 0.321591 102.994 0.893005C103.566 1.46442 103.888 2.23938 103.889 3.04763ZM123.444 3.04763C123.445 3.6505 123.266 4.23989 122.93 4.74105C122.594 5.24222 122.117 5.6326 121.559 5.86271C121.142 6.03472 120.691 6.11237 120.241 6.09008C119.79 6.06779 119.349 5.94612 118.951 5.7338C118.553 5.52148 118.207 5.22378 117.938 4.86208C117.669 4.50039 117.483 4.08367 117.394 3.64185C117.305 3.19974 117.316 2.74344 117.425 2.30596C117.535 1.86847 117.74 1.46073 118.027 1.11223C118.314 0.763719 118.674 0.483159 119.083 0.290834C119.491 0.0985086 119.938 -0.000773214 120.389 0.000168145C121.199 0.000753416 121.975 0.321941 122.548 0.893261C123.121 1.46458 123.443 2.23937 123.444 3.04763ZM142.999 3.04763C142.999 3.65054 142.82 4.23998 142.485 4.74118C142.149 5.24237 141.672 5.63273 141.113 5.86271C140.555 6.09273 139.942 6.15265 139.35 6.03489C138.758 5.91714 138.214 5.627 137.787 5.20107C137.36 4.77515 137.069 4.23254 136.951 3.64171C136.833 3.05088 136.892 2.43832 137.123 1.88132C137.315 1.41866 137.62 1.01053 138.008 0.692983C138.396 0.375434 138.857 0.158234 139.349 0.0605658C139.842 -0.0371028 140.351 -0.0122344 140.831 0.132975C141.312 0.278184 141.749 0.539265 142.104 0.89316C142.388 1.17591 142.613 1.51175 142.767 1.88145C142.92 2.25114 142.999 2.64743 142.999 3.04763Z"
                                        fill="currentColor"
                                    />
                                </g>
                            </svg>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    )
}
