<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <?php echo SEO::generate(); ?>

    <?php
    $menuRepository = app(\App\Repositories\Admin\MenuRepository::class);
    $main_menu = $menuRepository->getMenus('main_menu');
    $services_menu = $menuRepository->getMenus('services_menu');
    $footer_menu = $menuRepository->getMenus('footer_menu');
    $resources_menu = $menuRepository->getMenus('resources_menu');
    $useful_links = $menuRepository->getMenus('useful_links');
    $page_settings = app(\App\Repositories\SettingRepository::class)->getPageSettingInfo();
    $settings = app(\App\Repositories\SettingRepository::class);
    $customize_settings = $settings->getSiteSettings();
    $customize_settings['social_links']['social_list'] = json_decode($customize_settings['social_links']['social_list']);
    $fav_icon = \App\Models\Setting::pull('site_favicon');
    $primary_font = \App\Models\Setting::pull('primary_font');
    $secondary_font = \App\Models\Setting::pull('secondary_font');
    $google_captcha_site_key = \App\Models\Setting::pull('google_captcha_site_key');
    $is_active_google_captcha = \App\Models\Setting::pull('is_active_google_captcha');
    $is_show_cookie_alert = \App\Models\Setting::pull('is_show_cookie_alert');
    $is_enabled_ecommerce = \App\Models\Setting::pull('is_enabled_ecommerce');
    $meta_title = \App\Models\Setting::pull('meta_title');
    $meta_description = \App\Models\Setting::pull('meta_description');
    $meta_image = asset(\App\Models\Setting::pull('meta_image'));
    $blogs = app(\App\Repositories\Frontend\BlogRepository::class)->getPublishedBlogs();
    $popular_products = app(\App\Repositories\Frontend\ProductRepository::class)->getPopularProducts();
    $trending_products = app(\App\Repositories\Frontend\ProductRepository::class)->getTrendingProducts();

    $recent_post = \App\Models\Post::where('status', '1')->with('content')->latest()->take(4)->get();
    $categories = \App\Models\Category::with('content')->withCount('posts')->get();
    $tags = \App\Models\Tag::whereHas('posts')->pluck('name');

    $meta_tags = \App\Models\Setting::pull('meta_tags');
    $current_lang = app()->getLocale();
    $languageSettings = json_decode(\App\Models\Setting::pull('languages'), true);
    $direction = $languageSettings[$current_lang]['is_ltr'] === 'no' ? 'rtl' : '';
    $langJson = Illuminate\Support\Facades\File::get(base_path("lang/${current_lang}.json"));
    $jsonLang = json_decode($langJson, true);
    ?>

    <meta name="robots" content="index, follow">
    <meta name="keywords" content="<?php echo e($meta_tags); ?>">

    <!-- Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=<?php echo e($primary_font); ?>:wght@400;500;600;700;800;900&display=swap"
        rel="stylesheet" />
    <link
        href="https://fonts.googleapis.com/css2?family=<?php echo e($secondary_font); ?>:wght@400;500;600;700;800;900&display=swap"
        rel="stylesheet" />
    <link rel="stylesheet" href="<?php echo e(mix('css/frontend/globals.css')); ?>">
    <script src="<?php echo e(mix('js/frontend/app.js')); ?>" defer></script>
    <link rel="stylesheet" href="<?php echo e(route('custom.css')); ?>" />

    <link rel="icon" type="image/x-icon" href="<?php echo e($fav_icon); ?>">

    <script>
        localStorage.setItem('translation', JSON.stringify(<?php echo json_encode($jsonLang, 15, 512) ?>));
        localStorage.setItem('main_menu', JSON.stringify(<?php echo json_encode($main_menu, 15, 512) ?>));
        localStorage.setItem('services_menu', JSON.stringify(<?php echo json_encode($services_menu, 15, 512) ?>));
        localStorage.setItem('footer_menu', JSON.stringify(<?php echo json_encode($footer_menu, 15, 512) ?>));
        localStorage.setItem('resources_menu', JSON.stringify(<?php echo json_encode($resources_menu, 15, 512) ?>));
        localStorage.setItem('google_captcha_site_key', JSON.stringify(<?php echo json_encode($google_captcha_site_key, 15, 512) ?>));
        localStorage.setItem('is_active_google_captcha', JSON.stringify(<?php echo json_encode($is_active_google_captcha, 15, 512) ?>));
        localStorage.setItem('is_show_cookie_alert', JSON.stringify(<?php echo json_encode($is_show_cookie_alert, 15, 512) ?>));
        localStorage.setItem('is_enabled_ecommerce', JSON.stringify(<?php echo json_encode($is_enabled_ecommerce, 15, 512) ?>));
        localStorage.setItem('useful_links', JSON.stringify(<?php echo json_encode($useful_links, 15, 512) ?>));
        localStorage.setItem('blogs', JSON.stringify(<?php echo json_encode($blogs, 15, 512) ?>));

        localStorage.setItem('recent_post', JSON.stringify(<?php echo json_encode($recent_post, 15, 512) ?>));
        localStorage.setItem('categories', JSON.stringify(<?php echo json_encode($categories, 15, 512) ?>));
        localStorage.setItem('tags', JSON.stringify(<?php echo json_encode($tags, 15, 512) ?>));
        
        localStorage.setItem('popular_products', JSON.stringify(<?php echo json_encode($popular_products, 15, 512) ?>));
        localStorage.setItem('trending_products', JSON.stringify(<?php echo json_encode($trending_products, 15, 512) ?>));

        localStorage.setItem('customize_settings', JSON.stringify(<?php echo json_encode($customize_settings, 15, 512) ?>));
        localStorage.setItem('page_settings', JSON.stringify(<?php echo json_encode($page_settings, 15, 512) ?>));

        window.seo = {
            meta_title: "<?php echo e(e($meta_title)); ?>",
            meta_description: "<?php echo e(e($meta_description)); ?>",
            meta_image: "<?php echo e($meta_image); ?>",
            meta_tags: "<?php echo e(e($meta_tags)); ?>",
            og_url: "<?php echo e(url('/')); ?>"
        };
    </script>

    <?php if (!isset($__inertiaSsrDispatched)) { $__inertiaSsrDispatched = true; $__inertiaSsrResponse = app(\Inertia\Ssr\Gateway::class)->dispatch($page); }  if ($__inertiaSsrResponse) { echo $__inertiaSsrResponse->head; } ?>
    <?php echo app('Tighten\Ziggy\BladeRouteGenerator')->generate(); ?>
</head>

<body class="font-sans antialiased <?php echo e($direction); ?>">
    <?php if (!isset($__inertiaSsrDispatched)) { $__inertiaSsrDispatched = true; $__inertiaSsrResponse = app(\Inertia\Ssr\Gateway::class)->dispatch($page); }  if ($__inertiaSsrResponse) { echo $__inertiaSsrResponse->body; } else { ?><div id="app" data-page="<?php echo e(json_encode($page)); ?>"></div><?php } ?>

    <?php echo \App\Models\Setting::pull('html_embed_code'); ?>

</body>

</html><?php /**PATH /Users/mehedi/www/bione-laravel/resources/views/frontend.blade.php ENDPATH**/ ?>