<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <title><?php echo app('translator')->get('Order Confirmation'); ?></title>
    <?php
    $currency = app(\App\Repositories\SettingRepository::class)->getCurrencySettingInfo();
    ?>
    <style>
        /* Reset */
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        /* Page Styling */
        body {
            direction: <?php echo $direction; ?>;
            text-align: <?php echo $text_align; ?>;
            font-family: <?php echo $font_family; ?>;
            font-size: 12px;
            color: #333;
            background: #fff;
            position: relative;
        }



        /* Main Container */
        .container {
            width: 90%;
            margin: 0 auto;
            background: #fff;
            padding: 20px;
            position: relative;
        }

        /* Header Section */
        .header {
            text-align: center;
            margin-bottom: 20px;
        }

        .header img {
            max-width: 150px;
            margin-bottom: 10px;
        }

        .header h1 {
            font-size: 24px;
            color: #2d2d2d;
            margin-bottom: 5px;
        }

        .header p {
            font-size: 14px;
            color: #555;
        }

        .booking-details {
            margin-bottom: 20px;
        }

        .booking-details h2 {
            font-size: 18px;
            color: #2d2d2d;
            margin-bottom: 10px;
            border-bottom: 1px solid #ddd;
            padding-bottom: 5px;
        }

        .booking-details .detail {
            margin-bottom: 8px;
        }

        .detail label {
            font-weight: bold;
            color: #2d2d2d;
        }

        /* Table Styles */
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 10px;
        }

        table,
        th,
        td {
            border: 1px solid #ddd;
        }

        th,
        td {
            padding: 8px;
            text-align: <?php echo $text_align; ?>;
            font-size: 12px;
        }

        th {
            background-color: #f0f0f0;
            color: #333;
        }

        /* Footer Section */
        .footer {
            position: fixed;
            bottom: 0;
            left: 0;
            text-align: center;
            font-size: 10px;
            color: #555;
            padding: 10px;
            background: #fff;
        }

        /* Watermark Styling */
        .watermark {
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%) rotate(-30deg);
            font-size: 80px;
            color: rgb(0, 128, 0);
            font-weight: bold;
            z-index: 100;
            text-align: center;
            opacity: 0.2;
        }

        .summary-item {
            text-align: right;
            margin-top: 5px;
        }

        .summary-items {
            margin-top: 10px;
        }
    </style>
</head>

<body>
    <!-- Watermark -->
    
    
    

    <div class="container">
        <!-- Header Section -->
        <div class="header">
            <img src="<?php echo e(asset($invoice_logo)); ?>" alt="Invoice Logo">
            <h1><?php echo app('translator')->get('Order Invoice Title'); ?></h1>
            <p><?php echo app('translator')->get('Order Invoice Subtitle'); ?></p>
        </div>

        <!-- Order Details -->
        <div class="booking-details">
            <h2><?php echo app('translator')->get('Order Details'); ?></h2>
            <div class="detail"><label><?php echo app('translator')->get('Order Number'); ?></label> #<?php echo e($order->order_number); ?></div>
            <div class="detail"><label><?php echo app('translator')->get('Customer Name'); ?></label> <?php echo e($order->customer_name); ?></div>
        </div>

        <!-- Product Summary -->
        <div class="charges-details">
            <h2><?php echo app('translator')->get('Product Summary'); ?></h2>
            <table>
                <tr>
                    <th><?php echo app('translator')->get('Product Title'); ?></th>
                    <th style="text-align: right;"><?php echo app('translator')->get('Price'); ?></th>
                    <th style="text-align: right;"><?php echo app('translator')->get('Total'); ?></th>
                </tr>
                <?php $__currentLoopData = $order->orderitems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e($item?->product_name ?? 'N/A'); ?> (x<?php echo e($item->quantity); ?>)</td>
                    <td style="text-align: right;"><?php echo e(format_currency($item?->product_price, $currency)); ?></td>
                    <td style="text-align: right;"><?php echo e(format_currency($item?->product_price * $item->quantity, $currency)); ?></td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </table>
            <div class="summary-items">
                <div class="summary-item"><strong><?php echo app('translator')->get('Subtotal'); ?></strong>: <?php echo e(format_currency($order->total_price, $currency)); ?></div>
                <div class="summary-item"><strong><?php echo app('translator')->get('Discount'); ?></strong>: -<?php echo e(format_currency($order->discount, $currency)); ?></div>
                <div class="summary-item"><strong><?php echo app('translator')->get('Grand Total'); ?></strong>: <?php echo e(format_currency($order->total_price - $order->discount, $currency)); ?></div>
            </div>
        </div>

        <!-- Footer -->
        <div class="footer">
            <p><?php echo app('translator')->get('Address'); ?> <?php echo e($footer_address); ?></p>
            <p><?php echo app('translator')->get('Contact Us'); ?> <?php echo e($footer_contact); ?></p>
        </div>
    </div>
</body>

</html><?php /**PATH /www/wwwroot/bione-laravel.laralink.com/resources/views/invoice.blade.php ENDPATH**/ ?>