<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <title inertia><?php echo e(config('app.name', 'Laravel')); ?></title>


    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=figtree:400,500,600&display=swap" rel="stylesheet" />

    <?php
    $menuRepository = app(\App\Repositories\Admin\MenuRepository::class);
    $main_menu = $menuRepository->getMenus('main_menu');
    $services_menu = $menuRepository->getMenus('services_menu');
    $footer_menu = $menuRepository->getMenus('footer_menu');
    $resources_menu = $menuRepository->getMenus('resources_menu');
    $useful_links = $menuRepository->getMenus('useful_links');
    $page_settings = app(\App\Repositories\SettingRepository::class)->getPageSettingInfo();
    $google_captcha_site_key = \App\Models\Setting::pull('google_captcha_site_key');
    $is_active_google_captcha = \App\Models\Setting::pull('is_active_google_captcha');
    $is_enabled_ecommerce = \App\Models\Setting::pull('is_enabled_ecommerce');

    $settings = app(\App\Repositories\SettingRepository::class);
    $customize_settings = $settings->getSiteSettings();
    $customize_settings['social_links']['social_list'] = json_decode($customize_settings['social_links']['social_list']);
    $fav_icon = \App\Models\Setting::pull('site_favicon');
    $blogs = app(\App\Repositories\Frontend\BlogRepository::class)->getPublishedBlogs();
    $recent_post = \App\Models\Post::where('status', '1')->with('content')->latest()->take(4)->get();
    $categories = \App\Models\Category::with('content')->withCount('posts')->get();
    $tags = \App\Models\Tag::whereHas('posts')->pluck('name');

    $current_lang = app()->getLocale();
    $languageSettings = json_decode(\App\Models\Setting::pull('languages'), true);
    $direction = $languageSettings[$current_lang]['is_ltr'] === 'no' ? 'rtl' : '';
    $langJson = Illuminate\Support\Facades\File::get(base_path("lang/${current_lang}.json"));
    $jsonLang = json_decode($langJson, true);
    ?>
    <!-- Scripts -->
    <?php echo app('Tighten\Ziggy\BladeRouteGenerator')->generate(); ?>
    <link rel="stylesheet" href="<?php echo e(mix('css/admin/all.css')); ?>">
    <script src="<?php echo e(mix('js/admin/app.js')); ?>" defer></script>

    <link rel="icon" type="image/x-icon" href="<?php echo e($fav_icon); ?>">

    <script>
        localStorage.setItem('translation', JSON.stringify(<?php echo json_encode($jsonLang, 15, 512) ?>));
        localStorage.setItem('main_menu', JSON.stringify(<?php echo json_encode($main_menu, 15, 512) ?>));
        localStorage.setItem('services_menu', JSON.stringify(<?php echo json_encode($services_menu, 15, 512) ?>));
        localStorage.setItem('footer_menu', JSON.stringify(<?php echo json_encode($footer_menu, 15, 512) ?>));
        localStorage.setItem('resources_menu', JSON.stringify(<?php echo json_encode($resources_menu, 15, 512) ?>));
        localStorage.setItem('useful_links', JSON.stringify(<?php echo json_encode($useful_links, 15, 512) ?>));
        localStorage.setItem('blogs', JSON.stringify(<?php echo json_encode($blogs, 15, 512) ?>));

        localStorage.setItem('recent_post', JSON.stringify(<?php echo json_encode($recent_post, 15, 512) ?>));
        localStorage.setItem('categories', JSON.stringify(<?php echo json_encode($categories, 15, 512) ?>));
        localStorage.setItem('tags', JSON.stringify(<?php echo json_encode($tags, 15, 512) ?>));

        localStorage.setItem('customize_settings', JSON.stringify(<?php echo json_encode($customize_settings, 15, 512) ?>));
        localStorage.setItem('google_captcha_site_key', JSON.stringify(<?php echo json_encode($google_captcha_site_key, 15, 512) ?>));
        localStorage.setItem('is_active_google_captcha', JSON.stringify(<?php echo json_encode($is_active_google_captcha, 15, 512) ?>));
        localStorage.setItem('is_enabled_ecommerce', JSON.stringify(<?php echo json_encode($is_enabled_ecommerce, 15, 512) ?>));
        localStorage.setItem('page_settings', JSON.stringify(<?php echo json_encode($page_settings, 15, 512) ?>));
    </script>
    <?php if (!isset($__inertiaSsrDispatched)) { $__inertiaSsrDispatched = true; $__inertiaSsrResponse = app(\Inertia\Ssr\Gateway::class)->dispatch($page); }  if ($__inertiaSsrResponse) { echo $__inertiaSsrResponse->head; } ?>
</head>

<body class="font-sans antialiased <?php echo e($direction); ?>">
    <?php if (!isset($__inertiaSsrDispatched)) { $__inertiaSsrDispatched = true; $__inertiaSsrResponse = app(\Inertia\Ssr\Gateway::class)->dispatch($page); }  if ($__inertiaSsrResponse) { echo $__inertiaSsrResponse->body; } else { ?><div id="app" data-page="<?php echo e(json_encode($page)); ?>"></div><?php } ?>
</body>

</html><?php /**PATH /www/wwwroot/bione-laravel.laralink.com/resources/views/admin.blade.php ENDPATH**/ ?>